namespace POSGkSwaggerModel
{
    /// <summary>
    /// RetailTransactionLineItemExtension.Key Inner class for composite key attributes
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoRetailTransactionLineItemExtensionKey	{
        /// <summary>
        /// A unique system assigned identifier for a group of BusinessUnits.
        /// </summary>
        /// <value>A unique system assigned identifier for a group of BusinessUnits.</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// A universally unique identifier for the Transaction. This may be assembled from alternate key members. 
        /// </summary>
        /// <value>A universally unique identifier for the Transaction. This may be assembled from alternate key members. </value>
        public string transactionID { get; init; }
        /// <summary>
        /// The sequence number of line item within the context of this RetailTransaction. 
        /// </summary>
        /// <value>The sequence number of line item within the context of this RetailTransaction. </value>
        public int? retailTransactionLineItemSequenceNumber { get; init; }
        /// <summary>
        /// The key of the key-value pair 
        /// </summary>
        /// <value>The key of the key-value pair </value>
        public string extensionKey { get; init; }
        /// <summary>
        /// Line number (incremental counter) - there may exist multiple rows per ExtensionKey
        /// </summary>
        /// <value>Line number (incremental counter) - there may exist multiple rows per ExtensionKey</value>
        public int? extensionSequenceNumber { get; init; }
	}
}
