namespace POSGkSwaggerModel
{
    /// <summary>
    /// RetailTransactionModifierCoupon.Key Inner class for composite key attributes
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoRetailTransactionModifierCouponKey	{
        /// <summary>
        /// A unique system assigned identifier for a group of BusinessUnits.
        /// </summary>
        /// <value>A unique system assigned identifier for a group of BusinessUnits.</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. 
        /// </summary>
        /// <value>A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. </value>
        public string transactionID { get; init; }
        /// <summary>
        /// The unique identifier of the promotion.
        /// </summary>
        /// <value>The unique identifier of the promotion.</value>
        public string promotionID { get; init; }
        /// <summary>
        /// The unique identifier of the price derivation rule. 
        /// </summary>
        /// <value>The unique identifier of the price derivation rule. </value>
        public string priceDerivationRuleID { get; init; }
        /// <summary>
        /// The unique identifier of the root eligibility.
        /// </summary>
        /// <value>The unique identifier of the root eligibility.</value>
        public string priceDerivationRuleEligibilityID { get; init; }
        /// <summary>
        /// The sequential number of the coupon entry (starting with 1), in case there was more than one coupon registered for one modifier 
        /// </summary>
        /// <value>The sequential number of the coupon entry (starting with 1), in case there was more than one coupon registered for one modifier </value>
        public int? couponSequenceNumber { get; init; }
	}
}
