namespace POSGkSwaggerModel
{
    /// <summary>
    /// SaleReturnLineItemMerchandiseHierarchyGroup.Key Inner class for composite key attributes
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoSaleReturnLineItemMerchandiseHierarchyGroupKey	{
        /// <summary>
        /// A unique system assigned identifier for a group of BusinessUnits.
        /// </summary>
        /// <value>A unique system assigned identifier for a group of BusinessUnits.</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. 
        /// </summary>
        /// <value>A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. </value>
        public string transactionID { get; init; }
        /// <summary>
        /// The sequence number of line item within the context of this RetailTransaction. 
        /// </summary>
        /// <value>The sequence number of line item within the context of this RetailTransaction. </value>
        public int? retailTransactionLineItemSequenceNumber { get; init; }
        /// <summary>
        /// Qualifier which is used to differ between MerchandiseHierarchyGroup&#39;s belonging to different functions but having the same id 
        /// </summary>
        /// <value>Qualifier which is used to differ between MerchandiseHierarchyGroup&#39;s belonging to different functions but having the same id </value>
        public string merchandiseHierarchyGroupIDQualifier { get; init; }
        /// <summary>
        /// Unique system assigned identifier for the merchandise group. 
        /// </summary>
        /// <value>Unique system assigned identifier for the merchandise group. </value>
        public string merchandiseHierarchyGroupID { get; init; }
	}
}
