namespace POSGkSwaggerModel
{
    /// <summary>
    /// TenderAuthorization &lt;emph&gt;undocumented&lt;/emph&gt;
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoTenderAuthorization	{
        /// <summary>
        /// &lt;p&gt;Getter for inner key class.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Getter for inner key class.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiTxpoolDtoTenderAuthorizationkey key { get; init; }
        /// <summary>
        /// The sequence number of line item within the context of this RetailTransaction. 
        /// </summary>
        /// <value>The sequence number of line item within the context of this RetailTransaction. </value>
        public int? tenderLineItemSequenceNumber { get; init; }
        /// <summary>
        /// A code denoting which kind of card is being accepted. 
        /// </summary>
        /// <value>A code denoting which kind of card is being accepted. </value>
        public string cardType { get; init; }
        /// <summary>
        /// The account number appearing on a debit/credit card and identifying the card issuer&#39;s customer account to be charged or credited for the transaction. 
        /// </summary>
        /// <value>The account number appearing on a debit/credit card and identifying the card issuer&#39;s customer account to be charged or credited for the transaction. </value>
        public string accountNumber { get; init; }
        /// <summary>
        /// The IssueSequence number of the credit card being used. 
        /// </summary>
        /// <value>The IssueSequence number of the credit card being used. </value>
        public string cardIssueSequenceNumber { get; init; }
        /// <summary>
        /// The expiration date of the Credit or Debit card, as taken from the card in MMYY format. 
        /// </summary>
        /// <value>The expiration date of the Credit or Debit card, as taken from the card in MMYY format. </value>
        public string cardExpirationDate { get; init; }
        /// <summary>
        /// A unique identifier (which may be assigned by the external authorization agency) for this TenderAuthorization 
        /// </summary>
        /// <value>A unique identifier (which may be assigned by the external authorization agency) for this TenderAuthorization </value>
        public string referenceNumber { get; init; }
        /// <summary>
        /// The status of of the card transaction
        /// </summary>
        /// <value>The status of of the card transaction</value>
        public int? terminalTransactionStatus { get; init; }
        /// <summary>
        /// The last error message sent by the terminal 
        /// </summary>
        /// <value>The last error message sent by the terminal </value>
        public int? terminalTransactionErrorNumber { get; init; }
        /// <summary>
        /// The type of the terminal transaction 
        /// </summary>
        /// <value>The type of the terminal transaction </value>
        public int? terminalTransactionType { get; init; }
        /// <summary>
        /// Denotes that the Tender was authorized within the retail enterprise (usually because the connection to the host was down) and this TenderAuthorization must be approved by the host when it comes online. 
        /// </summary>
        /// <value>Denotes that the Tender was authorized within the retail enterprise (usually because the connection to the host was down) and this TenderAuthorization must be approved by the host when it comes online. </value>
        public bool? forceOnlineFlag { get; init; }
        /// <summary>
        /// The monetary value of the purchases for which an authorization is being requested. &lt;br&gt;Fixed decimal precision expected, definition of used precision: double(16, 5). Be aware of this and round value!
        /// </summary>
        /// <value>The monetary value of the purchases for which an authorization is being requested. &lt;br&gt;Fixed decimal precision expected, definition of used precision: double(16, 5). Be aware of this and round value!</value>
        public double? requestedAmount { get; init; }
        /// <summary>
        /// The Date and Time the TenderAuthorization was made. This may be assigned by the external agency that is providing the TenderAuthorization. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>The Date and Time the TenderAuthorization was made. This may be assigned by the external agency that is providing the TenderAuthorization. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string authorizationDatetime { get; init; }
        /// <summary>
        /// The system time when the terminal transaction ended ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>The system time when the terminal transaction ended ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string terminalTransactionEndTimestamp { get; init; }
        /// <summary>
        /// A unique sequence number for this TenderAuthorization. Required because a particular TenderLineItem may have more than one TenderAuthorization attempt. 
        /// </summary>
        /// <value>A unique sequence number for this TenderAuthorization. Required because a particular TenderLineItem may have more than one TenderAuthorization attempt. </value>
        public int? relatedTenderAuthorizatonSequenceNumber { get; init; }
        /// <summary>
        /// The transaction sequence number of the terminal 
        /// </summary>
        /// <value>The transaction sequence number of the terminal </value>
        public string terminalSequenceNumber { get; init; }
        /// <summary>
        /// Numeric code assigned by ISO to identify national currencies 
        /// </summary>
        /// <value>Numeric code assigned by ISO to identify national currencies </value>
        public string requestedISOCurrencyNumber { get; init; }
        /// <summary>
        /// A code denoting how a CardHolder was verified during a TenderAuthorization.
        /// </summary>
        /// <value>A code denoting how a CardHolder was verified during a TenderAuthorization.</value>
        public string cardHolderVerificationTypeCode { get; init; }
        /// <summary>
        /// A unique identifier (usually assigned by an external agency that provides TenderAuthorizations) that identifies the terminal performing the TenderAuthorization. 
        /// </summary>
        /// <value>A unique identifier (usually assigned by an external agency that provides TenderAuthorizations) that identifies the terminal performing the TenderAuthorization. </value>
        public int? tenderAuthorizationTerminalID { get; init; }
        /// <summary>
        /// Unique identifier of terminal transaction 
        /// </summary>
        /// <value>Unique identifier of terminal transaction </value>
        public int? traceNumber { get; init; }
        /// <summary>
        /// Used terminal defined in POS configuration.(e.g. „REAECT“, „Thales“, „Secpos“, ...) If the payment is carried out without a terminal or the terminal is not connected to the cash register: &#39;OFFLINE&#39; This information is necessary for later cancellation of the terminal payment. 
        /// </summary>
        /// <value>Used terminal defined in POS configuration.(e.g. „REAECT“, „Thales“, „Secpos“, ...) If the payment is carried out without a terminal or the terminal is not connected to the cash register: &#39;OFFLINE&#39; This information is necessary for later cancellation of the terminal payment. </value>
        public string terminalType { get; init; }
        /// <summary>
        /// A financial institution assigned identifier for ther Retail Enterprise or RetailStore that is conducting theTenderAuthorization. 
        /// </summary>
        /// <value>A financial institution assigned identifier for ther Retail Enterprise or RetailStore that is conducting theTenderAuthorization. </value>
        public string merchantNumber { get; init; }
        /// <summary>
        /// The terminal authorization number 
        /// </summary>
        /// <value>The terminal authorization number </value>
        public string approvalCode { get; init; }
        /// <summary>
        /// The adjudication code returned by the external agency to this TenderAuthorizationRequest 
        /// </summary>
        /// <value>The adjudication code returned by the external agency to this TenderAuthorizationRequest </value>
        public string adjudicationCode { get; init; }
        /// <summary>
        /// An error message in text form 
        /// </summary>
        /// <value>An error message in text form </value>
        public string adjudicationText { get; init; }
        /// <summary>
        /// A flag denoting that this TenderAuthorization was authorized by an external agency. 
        /// </summary>
        /// <value>A flag denoting that this TenderAuthorization was authorized by an external agency. </value>
        public bool? hostAuthorizedFlag { get; init; }
        /// <summary>
        /// The activation sequence number
        /// </summary>
        /// <value>The activation sequence number</value>
        public int? activationSequenceNumber { get; init; }
        /// <summary>
        /// The transaction reference number;is used in the context of purchase reservation and reservation adjustment
        /// </summary>
        /// <value>The transaction reference number;is used in the context of purchase reservation and reservation adjustment</value>
        public string terminalTransactionReferenceNumber { get; init; }
        /// <summary>
        /// The transaction type sent back by the terminal;possible transaction types are debit and credit
        /// </summary>
        /// <value>The transaction type sent back by the terminal;possible transaction types are debit and credit</value>
        public string terminalTransactionTypeCode { get; init; }
        /// <summary>
        /// The tender description sent back by the terminal
        /// </summary>
        /// <value>The tender description sent back by the terminal</value>
        public string terminalTenderDescription { get; init; }
        /// <summary>
        /// The application identifier sent back by the terminal
        /// </summary>
        /// <value>The application identifier sent back by the terminal</value>
        public string applicationID { get; init; }
        /// <summary>
        /// The (coded) application PAN sent back by the terminal
        /// </summary>
        /// <value>The (coded) application PAN sent back by the terminal</value>
        public string encryptedPAN { get; init; }
        /// <summary>
        /// The transaction currency code sent back by the terminal
        /// </summary>
        /// <value>The transaction currency code sent back by the terminal</value>
        public string terminalTransactionCurrencyCode { get; init; }
        /// <summary>
        /// The UTC0 Date and Time the TenderAuthorization was made. This may be assigned by the external agency that is providing the TenderAuthorization. ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>The UTC0 Date and Time the TenderAuthorization was made. This may be assigned by the external agency that is providing the TenderAuthorization. ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? authorizationDatetimeUTC0 { get; init; }
        /// <summary>
        /// The system time corresponding to UTC0 when the terminal transaction ended ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>The system time corresponding to UTC0 when the terminal transaction ended ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? terminalTransactionEndTimestampUTC0 { get; init; }
        /// <summary>
        /// The token is a unique number assigned by the payment processor to a card when a EFT transaction is processed. You can think of it like a replacement for the PAN that can be safely stored. This token needs to be retrieved from the terminal and stored in the DB (TenderAuthorization looks like the place to put it). The token is needed in order to do refunds/voids of previous EFT transactions without the need for the customer to swipe/insert their card on the terminal. In order for the terminal (T+) to do a void of an EFT transaction we need the token, reference number, approval code and amount. Currently only the approval code and amount is passed to the terminal for voids. The token and reference number are needed to be sent to the terminal for voids. The reference number is already stored in TenderAuthorization, it just needs to be passed to the terminal. Example: 0:AmEx:AX:997309203571006:0120
        /// </summary>
        /// <value>The token is a unique number assigned by the payment processor to a card when a EFT transaction is processed. You can think of it like a replacement for the PAN that can be safely stored. This token needs to be retrieved from the terminal and stored in the DB (TenderAuthorization looks like the place to put it). The token is needed in order to do refunds/voids of previous EFT transactions without the need for the customer to swipe/insert their card on the terminal. In order for the terminal (T+) to do a void of an EFT transaction we need the token, reference number, approval code and amount. Currently only the approval code and amount is passed to the terminal for voids. The token and reference number are needed to be sent to the terminal for voids. The reference number is already stored in TenderAuthorization, it just needs to be passed to the terminal. Example: 0:AmEx:AX:997309203571006:0120</value>
        public string terminalTransactionToken { get; init; }
        /// <summary>
        /// IBAN - International Bank Account Number for SEPA Direct Debit
        /// </summary>
        /// <value>IBAN - International Bank Account Number for SEPA Direct Debit</value>
        public string internationalBankAccountNumber { get; init; }
        /// <summary>
        /// BIC - Bank Identifier Code. Also known as SWIFT Code for SEPA Direct Debit.
        /// </summary>
        /// <value>BIC - Bank Identifier Code. Also known as SWIFT Code for SEPA Direct Debit.</value>
        public string bankIdentifierCode { get; init; }
        /// <summary>
        /// Creditor ID for SEPA Direct Debit (ELV)
        /// </summary>
        /// <value>Creditor ID for SEPA Direct Debit (ELV)</value>
        public string creditorID { get; init; }
        /// <summary>
        /// Mandate ID for SEPA Direct Debit (ELV)
        /// </summary>
        /// <value>Mandate ID for SEPA Direct Debit (ELV)</value>
        public string mandateID { get; init; }
        /// <summary>
        /// Pre-notification text for SEPA Direct Debit (ELV)
        /// </summary>
        /// <value>Pre-notification text for SEPA Direct Debit (ELV)</value>
        public string prenotificationText { get; init; }
        /// <summary>
        /// A unique identifier (usually assigned by an external agency that provides TenderAuthorizations) that identifies the terminal performing the TenderAuthorization. 
        /// </summary>
        /// <value>A unique identifier (usually assigned by an external agency that provides TenderAuthorizations) that identifies the terminal performing the TenderAuthorization. </value>
        public string tenderAuthorizationTerminalID2 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom01 { get; init; }
	}
}
