namespace POSGkSwaggerModel
{
    /// <summary>
    /// TransactionAssociation.Key Inner class for composite key attributes
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoTransactionAssociationKey	{
        /// <summary>
        /// Business unit group id of the current transaction.
        /// </summary>
        /// <value>Business unit group id of the current transaction.</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// Transaction ID of the current Transaction.
        /// </summary>
        /// <value>Transaction ID of the current Transaction.</value>
        public string transactionID { get; init; }
        /// <summary>
        /// Transaction ID of the referenced Transaction.
        /// </summary>
        /// <value>Transaction ID of the referenced Transaction.</value>
        public string toTransactionID { get; init; }
        /// <summary>
        /// Business unit group id of the referenced transaction.
        /// </summary>
        /// <value>Business unit group id of the referenced transaction.</value>
        public string toBusinessUnitGroupID { get; init; }
        /// <summary>
        /// A retailer assigned code denoting the relationship between the two transactions.
        /// </summary>
        /// <value>A retailer assigned code denoting the relationship between the two transactions.</value>
        public string transactionAssociationTypeCode { get; init; }
	}
}
