namespace POSGkSwaggerModel
{
    /// <summary>
    /// AuthorizationConfig &lt;p&gt;This configuration entity defines authorization related topics.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsAuthorizationConfig	{
        /// <summary>
        /// &lt;p&gt;This parameter defines the mode of authorization.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: AuthorizationMode [SINGLE, FOUREYES]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Single as &#39;SINGLE&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;FourEyes as &#39;FOUR_EYES&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the mode of authorization.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: AuthorizationMode [SINGLE, FOUREYES]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Single as &#39;SINGLE&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;FourEyes as &#39;FOUR_EYES&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public authorizationModeEnum authorizationMode { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the dialog type.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: AuthorizationDialogType [MANUAL, SCAN]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Manual as &#39;INPUT_FIELD&#39;: This setting allows both, manual input and authorization by barcode/msr scanner.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Scan as &#39;SCAN_EXPECT&#39;: Only the authorization by barcode/msr scanner is allowed (no manual input is possible).&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the dialog type.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: AuthorizationDialogType [MANUAL, SCAN]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Manual as &#39;INPUT_FIELD&#39;: This setting allows both, manual input and authorization by barcode/msr scanner.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Scan as &#39;SCAN_EXPECT&#39;: Only the authorization by barcode/msr scanner is allowed (no manual input is possible).&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public dialogTypeEnum dialogType { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines pos group operator selection action.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines pos group operator selection action.&lt;/p&gt;</value>
        public operatorSelectionActionEnum? operatorSelectionAction { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter indicates whether an explicit authorization is needed or not.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter indicates whether an explicit authorization is needed or not.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? authorizationRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;If the parameter authorizationRequired is enabled the operator permissions are checked against this right.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If the parameter authorizationRequired is enabled the operator permissions are checked against this right.&lt;/p&gt;</value>
        public string requiredRight { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether a cancellation is allowed. If it is set to true the authorization is allowed to be cancelled.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether a cancellation is allowed. If it is set to true the authorization is allowed to be cancelled.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? cancellationAllowed { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the password is required to pass the authorization.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the password is required to pass the authorization.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? passwordRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter is only relevant for the four eyes authorization.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;true - The second user must have rights to run the process.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;false - The authorization succeeds if any of the users has rights to start process.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter is only relevant for the four eyes authorization.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;true - The second user must have rights to run the process.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;false - The authorization succeeds if any of the users has rights to start process.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? checkSecondUserRights { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the predefined login name.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the predefined login name.&lt;/p&gt;</value>
        public string loginName { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the translation key for the name of the authorizing process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the translation key for the name of the authorizing process.&lt;/p&gt;</value>
        public string authorizingProcessNameKey { get; init; }
        /// <summary>
        /// &lt;p&gt;Prepared reason text of the authorizing process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Prepared reason text of the authorizing process.&lt;/p&gt;</value>
        public string authorizingReasonText { get; init; }
        /// <summary>
        /// &lt;p&gt;Translation key for the reason text of the authorizing process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Translation key for the reason text of the authorizing process.&lt;/p&gt;</value>
        public string authorizingReasonTextKey { get; init; }
        /// <summary>
        /// &lt;p&gt;Placeholder parameters for the reason text of the authorizing process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Placeholder parameters for the reason text of the authorizing process.&lt;/p&gt;</value>
        public List<string> AuthorizingReasonTextParameters { get; init; }
        /// <summary>
        /// &lt;p&gt;True - Regardless of whether an authorization has already been done in the current receipt,&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    the authorization shall be carried out.&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;p&gt;False: Is already noted a sufficient authorization, then this is used.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;True - Regardless of whether an authorization has already been done in the current receipt,&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    the authorization shall be carried out.&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;p&gt;False: Is already noted a sufficient authorization, then this is used.&lt;/p&gt;</value>
        public bool? askIfAlreadyAuthorized { get; init; }
        /// <summary>
        /// &lt;p&gt;True - resourceId will be stored to line Item.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;True - resourceId will be stored to line Item.&lt;/p&gt;</value>
        public bool? lineItemRelevant { get; init; }
        /// <summary>
        /// &lt;p&gt;False - resourceId will be not stored in RetailTransaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;False - resourceId will be not stored in RetailTransaction.&lt;/p&gt;</value>
        public bool? retailTransactionRelevant { get; init; }
        /// <summary>
        /// &lt;p&gt;False - resourceId will be not stored in ControlTransaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;False - resourceId will be not stored in ControlTransaction.&lt;/p&gt;</value>
        public bool? controlTransactionRelevant { get; init; }
        /// <summary>
        /// &lt;p&gt;False - resourceId will be not stored in TenderControlTransaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;False - resourceId will be not stored in TenderControlTransaction.&lt;/p&gt;</value>
        public bool? tenderControlTransactionRelevant { get; init; }
        /// <summary>
        /// &lt;p&gt;True: Error if no POS Group operator is active. Null/False: No activate POS Group operator check.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;True: Error if no POS Group operator is active. Null/False: No activate POS Group operator check.&lt;/p&gt;</value>
        public bool? activeOperatorRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
