namespace POSGkSwaggerModel
{
    /// <summary>
    /// CreateLayawayConfig &lt;p&gt;This configuration entity defines the create layaway process.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsCreateLayawayConfig	{
        /// <summary>
        /// &lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;</value>
        public string processId { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;</value>
        public bool? mainProcess { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines authorization related processes.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines authorization related processes.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsauthorizationConfig authorizationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines a list of item numbers/ EANs  (ItemID | POSItemID | MainPOSItemID) of the items, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined items are separated by semicolons &#39;;&#39;.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines a list of item numbers/ EANs  (ItemID | POSItemID | MainPOSItemID) of the items, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined items are separated by semicolons &#39;;&#39;.&lt;/p&gt;</value>
        public string allowedItemNrEanList { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines a list of merchandise hierarchy groups IDs, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined merchandise hierarchy groups IDs are separated by semicolons &#39;;&#39;.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines a list of merchandise hierarchy groups IDs, which are allowed to be part of the Layaway. If the list is empty, the value of this parameter is not checked. The defined merchandise hierarchy groups IDs are separated by semicolons &#39;;&#39;.&lt;/p&gt;</value>
        public string allowedMhgList { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the initial down payment amount in %.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the initial down payment amount in %.&lt;/p&gt;</value>
        public double? initialDownPayment { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the initial down payment amount as a fix amount in main currency.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the initial down payment amount as a fix amount in main currency.&lt;/p&gt;</value>
        public double? initialFixAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the validation time of the Layaway in days to calculate the final payment date based on the current date.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: Date of today &#x3D; 13.02.2018, layawayValidDays &#x3D; 28, final payment date &#x3D; 13.03.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the validation time of the Layaway in days to calculate the final payment date based on the current date.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: Date of today &#x3D; 13.02.2018, layawayValidDays &#x3D; 28, final payment date &#x3D; 13.03.2018&lt;/p&gt;</value>
        public int? layawayValidDays { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the validation date of the Layaway independent from the creation date of the layaway. If this parameter &amp;lt;&amp;gt; null, the value of parameter layawayValidDays is not used.&lt;br /&gt; Format: YYYY-MM-DD, e.g.: 2019-09-27&lt;br /&gt; Example: &lt;br /&gt; Date of today &#x3D; 01.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;br /&gt; Date of today &#x3D; 03.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the validation date of the Layaway independent from the creation date of the layaway. If this parameter &amp;lt;&amp;gt; null, the value of parameter layawayValidDays is not used.&lt;br /&gt; Format: YYYY-MM-DD, e.g.: 2019-09-27&lt;br /&gt; Example: &lt;br /&gt; Date of today &#x3D; 01.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;br /&gt; Date of today &#x3D; 03.10.2019, layawayValidDate &#x3D; 31.10.2019, final payment date &#x3D; 31.10.2019&lt;/p&gt;</value>
        public string layawayValidDate { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines every how many days a payment should be done, e.g. every 7 days or every 14 days&lt;br /&gt; Example: Date of today &#x3D; 13.02.2018, paymentDays&#x3D;7, pament dates &#x3D; 20.02.2018, 27.02.2018, 06.03.2018, 13.03.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines every how many days a payment should be done, e.g. every 7 days or every 14 days&lt;br /&gt; Example: Date of today &#x3D; 13.02.2018, paymentDays&#x3D;7, pament dates &#x3D; 20.02.2018, 27.02.2018, 06.03.2018, 13.03.2018&lt;/p&gt;</value>
        public int? paymentDays { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines how many days the final payment rate can be paid later than expected to calculate the latest final payment date.&lt;br /&gt; If the tolerance time is exceeded, the Layaway is canceled and the item goes back to the Store Stock.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final payment date &#x3D; 13.03.2018, toleranceTime &#x3D; 3, latest final payment date &#x3D; 16.03.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines how many days the final payment rate can be paid later than expected to calculate the latest final payment date.&lt;br /&gt; If the tolerance time is exceeded, the Layaway is canceled and the item goes back to the Store Stock.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final payment date &#x3D; 13.03.2018, toleranceTime &#x3D; 3, latest final payment date &#x3D; 16.03.2018&lt;/p&gt;</value>
        public int? toleranceTime { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines after how many days, beginning from the final expiration date (LatestFinalPaymentDate), the Layaway can be deleted. If the deleting time is exceeded, no actions (also no retrieving money from expired Layaway) can be performed.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final expiration date &#x3D; 01.03.2018, deletingTime &#x3D; 200, deleting date &#x3D; 17.09.2018&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines after how many days, beginning from the final expiration date (LatestFinalPaymentDate), the Layaway can be deleted. If the deleting time is exceeded, no actions (also no retrieving money from expired Layaway) can be performed.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Example: final expiration date &#x3D; 01.03.2018, deletingTime &#x3D; 200, deleting date &#x3D; 17.09.2018&lt;/p&gt;</value>
        public int? deletingTime { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the Service Fee in %.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Service Fee in %.&lt;/p&gt;</value>
        public double? serviceFeePercent { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the Amount of the Service Fee.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Amount of the Service Fee.&lt;/p&gt;</value>
        public double? serviceFeeAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the Cancellation Fee in % which is calculated, if the Layaway is voided.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Cancellation Fee in % which is calculated, if the Layaway is voided.&lt;/p&gt;</value>
        public double? cancellationFeePercent { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the Amount of the Cancellation Fee which is calculated, if the Layaway is voided.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the Amount of the Cancellation Fee which is calculated, if the Layaway is voided.&lt;/p&gt;</value>
        public double? cancellationFeeAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the percentage from the total layaway amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the percentage from the total layaway amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;</value>
        public double? penaltyFeePercent { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the fixed amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the fixed amount which is calculated, if the calculated payment date (defined by parameter layawayValidDays) + the tolerance time (defined by parameter toleranceTime) have expired.&lt;/p&gt;</value>
        public double? penaltyFeeAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the tax group of the several fees.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the tax group of the several fees.&lt;/p&gt;</value>
        public string feeTaxGroupId { get; init; }
        /// <summary>
        /// &lt;p&gt;Config for customer identification sub process&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Config for customer identification sub process&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowscustomerIdentificationConfig customerIdentificationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;Config for positionOperationConfig&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Config for positionOperationConfig&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessActionpositionOperationConfig positionOperationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
