namespace POSGkSwaggerModel
{
    /// <summary>
    /// CustomerIdentificationConfig &lt;p&gt;This config entity defines the CustomerIdentification process.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsCustomerIdentificationConfig	{
        /// <summary>
        /// &lt;p&gt;This parameter defines the customer identification function to use.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: CustomerIdentificationFunction [CUSTOMERREGISTRATION, CUSTOMERSEARCH, CUSTOMERDATAENTRY]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;CustomerRegistration as &#39;CustomerRegistration&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;CustomerSearch as &#39;CustomerSearch&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;CustomerDataEntry as &#39;CustomerDataEntry&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the customer identification function to use.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: CustomerIdentificationFunction [CUSTOMERREGISTRATION, CUSTOMERSEARCH, CUSTOMERDATAENTRY]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;CustomerRegistration as &#39;CustomerRegistration&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;CustomerSearch as &#39;CustomerSearch&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;CustomerDataEntry as &#39;CustomerDataEntry&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public customerIdentificationFunctionEnum? customerIdentificationFunction { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the card type which has to be used for the customer identification (set only if a restriction is neccessary).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the card type which has to be used for the customer identification (set only if a restriction is neccessary).&lt;/p&gt;</value>
        public string customerCardType { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter controls whether it is mandatory to enter a customer.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter controls whether it is mandatory to enter a customer.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? customerRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter controls if a missing customer identification will be signaled by an audible alert (it will work not before audible alerts can be implemented).&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter controls if a missing customer identification will be signaled by an audible alert (it will work not before audible alerts can be implemented).&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? customerRequiredAudibleAlert { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter controls if a message shall be triggered if the customer is required. At the same time there is a key for hinting a message.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter controls if a message shall be triggered if the customer is required. At the same time there is a key for hinting a message.&lt;/p&gt;</value>
        public string customerRequiredMessage { get; init; }
        /// <summary>
        /// &lt;p&gt;If one of the required conditions is not fulfilled then the warning customer data incomplete is displayed.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If one of the required conditions is not fulfilled then the warning customer data incomplete is displayed.&lt;/p&gt;</value>
        public string customerDataMissingMessage { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter controls if the customer identification process shall provide a customer ID of an identified customer for the use by calling the process.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter controls if the customer identification process shall provide a customer ID of an identified customer for the use by calling the process.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? retrieveCustomerId { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the config for the CustomerRegistration process. It is only in use if the customerIdentificationFunction is set to CustomerRegistration.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the config for the CustomerRegistration process. It is only in use if the customerIdentificationFunction is set to CustomerRegistration.&lt;/p&gt;</value>
        public string customerRegistrationConfigId { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the config for the CustomerSearch process. It is only in use if the customerIdentificationFunction is set to CustomerSearch.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the config for the CustomerSearch process. It is only in use if the customerIdentificationFunction is set to CustomerSearch.&lt;/p&gt;</value>
        public string customerSearchConfigId { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the config for the CustomerDataEntry process. It is only in use if the customerIdentificationFunction is set to CustomerDataEntry.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the config for the CustomerDataEntry process. It is only in use if the customerIdentificationFunction is set to CustomerDataEntry.&lt;/p&gt;</value>
        public string customerDataEntryConfigId { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the first name of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the first name of the customer is required.&lt;/p&gt;</value>
        public bool? firstNameRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the last name of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the last name of the customer is required.&lt;/p&gt;</value>
        public bool? lastNameRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the street of the default home address of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the street of the default home address of the customer is required.&lt;/p&gt;</value>
        public bool? streetRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the city of the default home address of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the city of the default home address of the customer is required.&lt;/p&gt;</value>
        public bool? cityRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the postal code of the default home address of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the postal code of the default home address of the customer is required.&lt;/p&gt;</value>
        public bool? postalCodeRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the federal state of the default home address of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the federal state of the default home address of the customer is required.&lt;/p&gt;</value>
        public bool? federalStateRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the country of the default home address of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the country of the default home address of the customer is required.&lt;/p&gt;</value>
        public bool? countryRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the tax id of the customer is required.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the tax id of the customer is required.&lt;/p&gt;</value>
        public bool? taxIdRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
