namespace POSGkSwaggerModel
{
    /// <summary>
    /// GoodsReturnConfig &lt;p&gt;This configuration entity defines the goods return process.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsGoodsReturnConfig	{
        /// <summary>
        /// &lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;</value>
        public string processId { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;</value>
        public bool? mainProcess { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines authorization related processes.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines authorization related processes.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsauthorizationConfig authorizationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether a return is performed without original receipt.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether a return is performed without original receipt.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? withOutOriginalSc { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether a customer must be assigned to the return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether a customer must be assigned to the return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? registerCustomer { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the return mode will be finished automatically after one return line item.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the return mode will be finished automatically after one return line item.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? onlyOneReturnPosition { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether a return receipt is created. This receipt includes only return line items.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether a return receipt is created. This receipt includes only return line items.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? createReturnReceipt { get; init; }
        /// <summary>
        /// Gets or Sets CustomerIdentificationConfig
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessFlowscustomerIdentificationConfig customerIdentificationConfig { get; init; }
        /// <summary>
        /// Gets or Sets AllowedTendersConfig
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessFlowsallowedTendersConfig allowedTendersConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the original business unit id must be entered in case of return without receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the original business unit id must be entered in case of return without receipt.&lt;/p&gt;</value>
        public bool? originalBusinessUnitIdRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the original date must be entered in case of return without receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the original date must be entered in case of return without receipt.&lt;/p&gt;</value>
        public bool? originalDateRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the original workstation id must be entered in case of return without receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the original workstation id must be entered in case of return without receipt.&lt;/p&gt;</value>
        public bool? originalWorkstationIdRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the original receipt number must be entered in case of return without receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the original receipt number must be entered in case of return without receipt.&lt;/p&gt;</value>
        public bool? originalSequenceNumberRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the original fiscal device number must be entered in case of return without receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the original fiscal device number must be entered in case of return without receipt.&lt;/p&gt;</value>
        public bool? originalFiscalDeviceNumberRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the original fiscal sequence number must be entered in case of return without receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the original fiscal sequence number must be entered in case of return without receipt.&lt;/p&gt;</value>
        public bool? originalFiscalSequenceNumberRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the original fiscal day number must be entered in case of return without receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the original fiscal day number must be entered in case of return without receipt.&lt;/p&gt;</value>
        public bool? originalFiscalDayNumberRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;Map of original receipt data to save in sale return line item extensions.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Map of original receipt data to save in sale return line item extensions.&lt;/p&gt;</value>
        public Dictionary<string, string> RequiredOriginalReceiptData { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines the return with transaction process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines the return with transaction process.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsreturnWithTransactionConfig returnWithTransactionConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
