namespace POSGkSwaggerModel
{
    /// <summary>
    /// ItemEntryConfig &lt;p&gt;This configuration entity defines itemEntry processes.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsItemEntryConfig	{
        /// <summary>
        /// &lt;p&gt;The parameter defines the provider for the item data. Default Local.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the provider for the item data. Default Local.&lt;/p&gt;</value>
        public itemProviderEnum? itemProvider { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;</value>
        public string processId { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;</value>
        public bool? mainProcess { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines authorization related processes.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines authorization related processes.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsauthorizationConfig authorizationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines a fixed item number/ EAN for fixed item keys.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines a fixed item number/ EAN for fixed item keys.&lt;/p&gt;</value>
        public string fixedItemNrEan { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the input for the item number/ EAN.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the input for the item number/ EAN.&lt;/p&gt;</value>
        public string itemNrEan { get; init; }
        /// <summary>
        /// &lt;p&gt;Input parameter for item traceable unit id (used for EPC codes scanned by RFID, for example)&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Input parameter for item traceable unit id (used for EPC codes scanned by RFID, for example)&lt;/p&gt;</value>
        public string itemTraceableUnitID { get; init; }
        /// <summary>
        /// &lt;p&gt;Raw barcode used for registration.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Raw barcode used for registration.&lt;/p&gt;</value>
        public string registrationNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines text class IDs.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines text class IDs.&lt;/p&gt;</value>
        public List<string> TextClassIds { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the unit of measure code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the unit of measure code.&lt;/p&gt;</value>
        public string uomCode { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether sales restrictions are verified. The default is set at true.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether sales restrictions are verified. The default is set at true.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? checkSalesRestrictions { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether sales restrictions are verified for return items. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether sales restrictions are verified for return items. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? checkSalesRestrictionsForReturn { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether a check is made for item variants. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether a check is made for item variants. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? checkForVariants { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the tax group should be validated.&lt;br /&gt; &lt;br/&gt;&lt;br /&gt; This means that the tax group exists in master data and fulfills the following conditions: TaxGroupRule.EffectiveDateTime &amp;lt;&#x3D; {current timestamp} and TaxGroupRule.ExpirationDateTime &amp;gt;&#x3D; {current timestamp}.&lt;br /&gt; &lt;br/&gt;&lt;br /&gt; The default is set at true.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the tax group should be validated.&lt;br /&gt; &lt;br/&gt;&lt;br /&gt; This means that the tax group exists in master data and fulfills the following conditions: TaxGroupRule.EffectiveDateTime &amp;lt;&#x3D; {current timestamp} and TaxGroupRule.ExpirationDateTime &amp;gt;&#x3D; {current timestamp}.&lt;br /&gt; &lt;br/&gt;&lt;br /&gt; The default is set at true.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? checkTaxGroup { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether a quantity is requested. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether a quantity is requested. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? askForQuantity { get; init; }
        /// <summary>
        /// Gets or Sets AgeVerificationRequired
        /// </summary>
        public bool? ageVerificationRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether seller age should be checked.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether seller age should be checked.&lt;/p&gt;</value>
        public bool? checkSellerAgeRestrictions { get; init; }
        /// <summary>
        /// Gets or Sets ConfirmDialogAgeVerifacation
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessUiMessageDialogConfig confirmDialogAgeVerifacation { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the line item amount.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the line item amount.&lt;/p&gt;</value>
        public double? positionAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the unit price.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the unit price.&lt;/p&gt;</value>
        public double? itemPrice { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the packaging quantity of an item.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the packaging quantity of an item.&lt;/p&gt;</value>
        public double? factor { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the single quantity in case of piece items.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the single quantity in case of piece items.&lt;/p&gt;</value>
        public int? itemQuantity { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the manual weight in case of weight items.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the manual weight in case of weight items.&lt;/p&gt;</value>
        public double? weight { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines the units in case of quantity with decimal places items (e.g. fuel items).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines the units in case of quantity with decimal places items (e.g. fuel items).&lt;/p&gt;</value>
        public double? units { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the serial number.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the serial number.&lt;/p&gt;</value>
        public string serialNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether an item is salable even if no price exists. The default is set at true.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether an item is salable even if no price exists. The default is set at true.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? saleableWithoutPrice { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the system switches to Item Search if no search term exists. The default is set at true.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the system switches to Item Search if no search term exists. The default is set at true.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? switchToItemSearch { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the receipt text of the item is requested. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the receipt text of the item is requested. The default is set at false.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? askForReceiptText { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the mode. The default is set at 0.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: 0, 1, 2&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;0 - The standard item entry is set.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;1 - The set component entry is set.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;2 - The Bulk Registration is set.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the mode. The default is set at 0.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: 0, 1, 2&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;0 - The standard item entry is set.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;1 - The set component entry is set.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;2 - The Bulk Registration is set.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public int? mode { get; init; }
        /// <summary>
        /// Gets or Sets CallPackageSelection
        /// </summary>
        public bool? callPackageSelection { get; init; }
        /// <summary>
        /// Gets or Sets ItemPackageSelectionId
        /// </summary>
        public string itemPackageSelectionId { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the total price entry is requested in case of return of weighing items. The value is set by Goods Return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the total price entry is requested in case of return of weighing items. The value is set by Goods Return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? returnManualPositionAmountForWeightItemsRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the reason is requested in case of returns. The value is set by Goods Return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the reason is requested in case of returns. The value is set by Goods Return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? returnReasonRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether a manual price entry is requested in case of returns. The value is set by Goods Return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether a manual price entry is requested in case of returns. The value is set by Goods Return.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? returnManualPriceRequired { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines the Enter ReceiptText Dialog.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines the Enter ReceiptText Dialog.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessUiPromptUserDialogConfig promptForReceiptTextConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines the Enter SerialNumber Dialog.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines the Enter SerialNumber Dialog.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessUiPromptUserDialogConfig promptForSerialNumberConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines the position operation for registering.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines the position operation for registering.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessActionpositionOperationConfig positionOperationConfig { get; init; }
        /// <summary>
        /// Gets or Sets PriceDifferenceLimitExceedAuthConfig
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessFlowsAuthorizationConfig priceDifferenceLimitExceedAuthConfig { get; init; }
        /// <summary>
        /// Gets or Sets PromotionOperationConfig
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessActionpromotionOperationConfig promotionOperationConfig { get; init; }
        /// <summary>
        /// Gets or Sets ForceManualWeight
        /// </summary>
        public bool? forceManualWeight { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if the quantity of line items with the same item should be accumulated.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if the quantity of line items with the same item should be accumulated.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? quantityAccumulation { get; init; }
        /// <summary>
        /// &lt;p&gt;It references the item details config to determine if additional info is needed&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It references the item details config to determine if additional info is needed&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsitemRegistrationConfig itemRegistrationConfig { get; init; }
        /// <summary>
        /// Gets or Sets ItemIDCaseSensitive
        /// </summary>
        public bool? itemIDCaseSensitive { get; init; }
        /// <summary>
        /// &lt;p&gt;It references the acoustic signal configuration identifier for manual price input&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It references the acoustic signal configuration identifier for manual price input&lt;/p&gt;</value>
        public string manualPriceAcousticSignalConfigId { get; init; }
        /// <summary>
        /// &lt;p&gt;It references the acoustic signal configuration identifier for quantity input&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It references the acoustic signal configuration identifier for quantity input&lt;/p&gt;</value>
        public string quantityAcousticSignalConfigId { get; init; }
        /// <summary>
        /// &lt;p&gt;It references the acoustic signal configuration identifier for serial number input&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It references the acoustic signal configuration identifier for serial number input&lt;/p&gt;</value>
        public string serialNumberAcousticSignalConfigId { get; init; }
        /// <summary>
        /// &lt;p&gt;It references the SetQuantityForLineItemConfig identifier for the SetQuantityForLineItem sub process call.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It references the SetQuantityForLineItemConfig identifier for the SetQuantityForLineItem sub process call.&lt;/p&gt;</value>
        public string setQuantityForLineItemConfigId { get; init; }
        /// <summary>
        /// Gets or Sets NegativePositionProhibited
        /// </summary>
        public bool? negativePositionProhibited { get; init; }
        /// <summary>
        /// Gets or Sets CustomerOrderData
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessFlowscustomerOrderData customerOrderData { get; init; }
        /// <summary>
        /// Gets or Sets RegisterLineItemAddOnData
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessFlowsRegisterLineItemAddonData registerLineItemAddOnData { get; init; }
        /// <summary>
        /// &lt;p&gt;References the instance of configuration which indicates additional item related attributes to be assigned to sale return line item extensions during item registration.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;References the instance of configuration which indicates additional item related attributes to be assigned to sale return line item extensions during item registration.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsadditionalAttributes additionalAttributes { get; init; }
        /// <summary>
        /// Gets or Sets RegisterFuelLineItem
        /// </summary>
        public ComGkSoftwarePosApiModelConfigProcessFlowsregisterFuelLineItem registerFuelLineItem { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines if an open line item (without item) will be removed if item entry fails with error.&lt;br /&gt; It should be set to true for barcode rules with multiple actions where second action is the item entry process.&lt;br /&gt; Default: null/false&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines if an open line item (without item) will be removed if item entry fails with error.&lt;br /&gt; It should be set to true for barcode rules with multiple actions where second action is the item entry process.&lt;br /&gt; Default: null/false&lt;/p&gt;</value>
        public bool? removeOpenLineItemOnError { get; init; }
        /// <summary>
        /// &lt;p&gt;config item not found authorization. Mainly to be used by POS clients that will display an authorization error on item search failure (Ex: SCO)&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;config item not found authorization. Mainly to be used by POS clients that will display an authorization error on item search failure (Ex: SCO)&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsAuthorizationConfig itemNotFoundAuthorizationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;config to handle remote service not available authorization errors, when doing remote item searches in SDC / SAP&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;config to handle remote service not available authorization errors, when doing remote item searches in SDC / SAP&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsAuthorizationConfig remoteServiceNotAvailableAuthorizationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;If true any forbidden dialogs for sales restrictions will be skipped.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If true any forbidden dialogs for sales restrictions will be skipped.&lt;/p&gt;</value>
        public bool? skipSalesRestrictionDialogs { get; init; }
        /// <summary>
        /// &lt;p&gt;If true any error dialogs triggered while setting quantity for line item will be skipped.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If true any error dialogs triggered while setting quantity for line item will be skipped.&lt;/p&gt;</value>
        public bool? skipQuantityErrorDialogs { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines the specific SalesRestriction configID for ItemEntryConfig, which will be overridden into sales restriction process (empty by default).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines the specific SalesRestriction configID for ItemEntryConfig, which will be overridden into sales restriction process (empty by default).&lt;/p&gt;</value>
        public string salesRestrictionConfigID { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
