namespace POSGkSwaggerModel
{
    /// <summary>
    /// GiftCertInfo &lt;p&gt;Contains gift certificate attributes returned by the stored value server.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelDomAppGiftCertificateServiceGiftCertInfo	{
        /// <summary>
        /// &lt;p&gt;Gift certificate id.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Gift certificate id.&lt;/p&gt;</value>
        public int? gcId { get; init; }
        /// <summary>
        /// &lt;p&gt;Gift certificate number.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Gift certificate number.&lt;/p&gt;</value>
        public string gcNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;Amount of the gift certificate.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Amount of the gift certificate.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppamountamount amount { get; init; }
        /// <summary>
        /// &lt;p&gt;Gift certificate status: SELLABLE, REDEEMABLE, LOCKED, INVALID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Gift certificate status: SELLABLE, REDEEMABLE, LOCKED, INVALID.&lt;/p&gt;</value>
        public string state { get; init; }
        /// <summary>
        /// &lt;p&gt;Start of gift certificate validity period.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Start of gift certificate validity period.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string validFrom { get; init; }
        /// <summary>
        /// &lt;p&gt;End of gift certificate validity period&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;End of gift certificate validity period&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string validTo { get; init; }
        /// <summary>
        /// &lt;p&gt;An unique transaction ID for the requested operation.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;An unique transaction ID for the requested operation.&lt;/p&gt;</value>
        public string uuid { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the handling of over payments (NOT_ACCEPTED, NO_CHANGE, GIFT_CERTIFICATE_CHANGE, CASH_CHANGE).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the handling of over payments (NOT_ACCEPTED, NO_CHANGE, GIFT_CERTIFICATE_CHANGE, CASH_CHANGE).&lt;/p&gt;</value>
        public string overpaymentType { get; init; }
        /// <summary>
        /// &lt;p&gt;Items that are not included when comparing the receipt total with the minimum transaction amount (MinSale).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Items that are not included when comparing the receipt total with the minimum transaction amount (MinSale).&lt;/p&gt;</value>
        public List<string> BlacklistedItems { get; init; }
        /// <summary>
        /// &lt;p&gt;Merchandise categories that are not included when comparing the receipt total with the minimum transaction  amount (MinSale).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Merchandise categories that are not included when comparing the receipt total with the minimum transaction  amount (MinSale).&lt;/p&gt;</value>
        public List<string> BlacklistedArticleGroupNumbers { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines if discounted items will be included into minimum sale check.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines if discounted items will be included into minimum sale check.&lt;/p&gt;</value>
        public bool? includeDiscountedArticlesToMinimumSale { get; init; }
        /// <summary>
        /// &lt;p&gt;Minimum amount for this gift certificate.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Minimum amount for this gift certificate.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppAmountAmount minimumTransactionAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional attributes for gift certificates sent by stored value server.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional attributes for gift certificates sent by stored value server.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppGiftCertificateServiceAttributeValue> AdditionalInfo { get; init; }
        /// <summary>
        /// Gets or Sets Track2
        /// </summary>
        public string track2 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
