namespace POSGkSwaggerModel
{
    /// <summary>
    /// RetailTransactionPriceDerivationRule &lt;p&gt;Retail transaction price derivation rule describes a promotion rule.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule	{
        /// <summary>
        /// &lt;p&gt;The unique identifier of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier of the promotion.&lt;/p&gt;</value>
        public string promotionID { get; init; }
        /// <summary>
        /// &lt;p&gt;The unique identifier of the price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier of the price derivation rule.&lt;/p&gt;</value>
        public string priceDerivationRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;The unique identifier of the root eligibility.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier of the root eligibility.&lt;/p&gt;</value>
        public string priceDerivationRuleEligibilityID { get; init; }
        /// <summary>
        /// &lt;p&gt;Short description of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Short description of the promotion.&lt;/p&gt;</value>
        public string promotionDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;Text to be printed on the receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Text to be printed on the receipt.&lt;/p&gt;</value>
        public string receiptPrinterName { get; init; }
        /// <summary>
        /// &lt;p&gt;Promotion price derivation rule Sequence used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleResolution.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Promotion price derivation rule Sequence used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleResolution.&lt;/p&gt;</value>
        public string promotionPriceDerivationRuleSequence { get; init; }
        /// <summary>
        /// &lt;p&gt;Promotion price derivation resolution used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleSequence.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Promotion price derivation resolution used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleSequence.&lt;/p&gt;</value>
        public string promotionPriceDerivationRuleResolution { get; init; }
        /// <summary>
        /// &lt;p&gt;The type code of the promotion price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The type code of the promotion price derivation rule.&lt;/p&gt;</value>
        public string promotionPriceDerivationRuleTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;A code denoting the method of modifying the price that is being applied to the transaction line item.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code denoting the method of modifying the price that is being applied to the transaction line item.&lt;/p&gt;</value>
        public string priceModificationMethodCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Business description for this price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Business description for this price derivation rule.&lt;/p&gt;</value>
        public string priceDerivationRuleDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;The type code of the originator of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The type code of the originator of the promotion.&lt;/p&gt;</value>
        public string promotionOriginatorTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The external identifier of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The external identifier of the promotion.&lt;/p&gt;</value>
        public string externalPromotionID { get; init; }
        /// <summary>
        /// &lt;p&gt;The external identifier of the price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The external identifier of the price derivation rule.&lt;/p&gt;</value>
        public string externalPriceDerivationRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;The quantity of items fulfilling the eligibility which is required in order to trigger the price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The quantity of items fulfilling the eligibility which is required in order to trigger the price derivation rule.&lt;/p&gt;</value>
        public double? triggerQuantity { get; init; }
        /// <summary>
        /// &lt;p&gt;End of the date range in which the gift certificate is valid.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;End of the date range in which the gift certificate is valid.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string giftCertificateExpirationDate { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines how the discount influences the transaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how the discount influences the transaction.&lt;/p&gt;</value>
        public string discountMethodCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the result of the applied price derivation rule is to be suppressed on displays / not printed on the receipt; e.g. line item-related default points are not printed after each position, but only summarized at the end of the receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the result of the applied price derivation rule is to be suppressed on displays / not printed on the receipt; e.g. line item-related default points are not printed after each position, but only summarized at the end of the receipt.&lt;/p&gt;</value>
        public bool? prohibitPrintFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A code which uniquely identifies the tender in case of rebate as tender.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code which uniquely identifies the tender in case of rebate as tender.&lt;/p&gt;</value>
        public string tenderTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Promotion type name&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Promotion type name&lt;/p&gt;</value>
        public string promotionTypeName { get; init; }
        /// <summary>
        /// Gets or Sets CalculationBase
        /// </summary>
        public string calculationBase { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent price derivation rules (false) or not (true).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent price derivation rules (false) or not (true).&lt;/p&gt;</value>
        public bool? noEffectOnSubsequentPriceDerivationRulesFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent transaction-related price derivation rules (false) or not (true); is relevant for line item-related &#39;money&#39; price derivation rules only.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent transaction-related price derivation rules (false) or not (true); is relevant for line item-related &#39;money&#39; price derivation rules only.&lt;/p&gt;</value>
        public bool? prohibitTransactionRelatedPriceDerivationRulesFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The number of the printout coupon.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The number of the printout coupon.&lt;/p&gt;</value>
        public string couponPrintoutID { get; init; }
        /// <summary>
        /// &lt;p&gt;The type code of the printout rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The type code of the printout rule.&lt;/p&gt;</value>
        public string couponPrintoutRule { get; init; }
        /// <summary>
        /// &lt;p&gt;The formatted text of the printout coupon.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The formatted text of the printout coupon.&lt;/p&gt;</value>
        public string couponPrintoutText { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this price derivation rule is an exclusive one.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this price derivation rule is an exclusive one.&lt;/p&gt;</value>
        public bool? exclusiveFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines how this price derivation rule works in relation to other applicable price derivation rules.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how this price derivation rule works in relation to other applicable price derivation rules.&lt;/p&gt;</value>
        public string concurrenceControlVector { get; init; }
        /// <summary>
        /// &lt;p&gt;Describes how often the current price derivation rule was applied.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Describes how often the current price derivation rule was applied.&lt;/p&gt;</value>
        public double? appliedCount { get; init; }
        /// <summary>
        /// &lt;p&gt;Describes how long (how many days) the printed coupon/gift certificate is valid.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Describes how long (how many days) the printed coupon/gift certificate is valid.&lt;/p&gt;</value>
        public double? printoutValidityPeriod { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
