namespace POSGkSwaggerModel
{
    /// <summary>
    /// ExternalCartData &lt;p&gt;Representation of an external cart provided by an external order service&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceExternalCartExternalCartData	{
        /// <summary>
        /// &lt;p&gt;The cart ID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The cart ID.&lt;/p&gt;</value>
        public string cartId { get; init; }
        /// <summary>
        /// &lt;p&gt;The customer ID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The customer ID.&lt;/p&gt;</value>
        public string customerId { get; init; }
        /// <summary>
        /// &lt;p&gt;The total item count of this cart.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The total item count of this cart.&lt;/p&gt;</value>
        public int? totalItems { get; init; }
        /// <summary>
        /// &lt;p&gt;The count of items to pick up in a store.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The count of items to pick up in a store.&lt;/p&gt;</value>
        public int? pickupItems { get; init; }
        /// <summary>
        /// &lt;p&gt;The count of items to be delivered.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The count of items to be delivered.&lt;/p&gt;</value>
        public int? deliveryItems { get; init; }
        /// <summary>
        /// &lt;p&gt;The total price of the whole cart, including discounts and delivery costs.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The total price of the whole cart, including discounts and delivery costs.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceExternalCartExternalCartDataPrice totalPrice { get; init; }
        /// <summary>
        /// &lt;p&gt;The costs for delivery, usually calculated after the external service has all parameters, like delivery mode and delivery address.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The costs for delivery, usually calculated after the external service has all parameters, like delivery mode and delivery address.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceExternalCartExternalCartDataPrice deliveryCost { get; init; }
        /// <summary>
        /// &lt;p&gt;The total amount of discounts applied to the cart by the external service.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The total amount of discounts applied to the cart by the external service.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceExternalCartExternalCartDataPrice totalDiscounts { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag signaling if the cart has been calculated and is ready for order.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag signaling if the cart has been calculated and is ready for order.&lt;/p&gt;</value>
        public bool? orderCalculated { get; init; }
        /// <summary>
        /// &lt;p&gt;The total price including taxes applied by the external service&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The total price including taxes applied by the external service&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceExternalCartExternalCartDataPrice totalPriceWithTax { get; init; }
        /// <summary>
        /// &lt;p&gt;The line items of the cart.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The line items of the cart.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceExternalCartExternalCartDataEntry> Entries { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
