namespace POSGkSwaggerModel
{
    /// <summary>
    /// AddFiscalizationDataToTransactionRequest &lt;p&gt;Request object to add fiscalization data to a transaction.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceTransactionAddFiscalizationDataToTransactionRequest	{
        /// <summary>
        /// &lt;p&gt;The identifier of the transaction where the fiscalization data should be set.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The identifier of the transaction where the fiscalization data should be set.&lt;/p&gt;</value>
        public string transactionId { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization day number.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization day number.&lt;/p&gt;</value>
        public string fiscalDayNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization printer identifier.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization printer identifier.&lt;/p&gt;</value>
        public string fiscalPrinterId { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate if it is a fiscalization receipt/transaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate if it is a fiscalization receipt/transaction.&lt;/p&gt;</value>
        public bool? fiscalReceipt { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization receipt number.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization receipt number.&lt;/p&gt;</value>
        public string fiscalReceiptNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization signature.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization signature.&lt;/p&gt;</value>
        public string fiscalSignature { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization receipt text.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization receipt text.&lt;/p&gt;</value>
        public string fiscalReceiptText { get; init; }
        /// <summary>
        /// &lt;p&gt;The encoded fiscalization barcode image.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The encoded fiscalization barcode image.&lt;/p&gt;</value>
        public string fiscalEncodedBarcodeImage { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization barcode reference.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization barcode reference.&lt;/p&gt;</value>
        public string fiscalBarcodeReference { get; init; }
        /// <summary>
        /// &lt;p&gt;The position operation configuration.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The position operation configuration.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessActionpositionOperationConfig positionOperationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization receipt security code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization receipt security code.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionFiscalTagFieldResult fiscalSecurity { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization receipt tax identifier.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization receipt tax identifier.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionFiscalTagFieldResult fiscalTaxId { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization receipt fiscal code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization receipt fiscal code.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionFiscalTagFieldResult fiscalCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization year.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization year.&lt;/p&gt;</value>
        public int? fiscalYear { get; init; }
        /// <summary>
        /// &lt;p&gt;The fiscalization signing key version.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The fiscalization signing key version.&lt;/p&gt;</value>
        public string keyVersion { get; init; }
        /// <summary>
        /// &lt;p&gt;Daily sum of digital signatures&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Daily sum of digital signatures&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionFiscalTagFieldResult signatureSumDaily { get; init; }
        /// <summary>
        /// &lt;p&gt;Total sum of digital signatures&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Total sum of digital signatures&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionFiscalTagFieldResult signatureSumPerpetual { get; init; }
        /// <summary>
        /// &lt;p&gt;Date and time of signature&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Date and time of signature&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionFiscalTagFieldResult timestamp { get; init; }
        /// <summary>
        /// &lt;p&gt;ESD serial number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;ESD serial number&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionFiscalTagFieldResult esdId { get; init; }
        /// <summary>
        /// &lt;p&gt;deprecated: as of 5.5.0. Use instead proper service to set flag&lt;br /&gt; A flag to indicate that the receipt was printed.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;deprecated: as of 5.5.0. Use instead proper service to set flag&lt;br /&gt; A flag to indicate that the receipt was printed.&lt;/p&gt;</value>
        public bool? receiptPrinted { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional extensions&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional extensions&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceTransactionExtension> Extensions { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional binary data extensions&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional binary data extensions&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceTransactionExtension> BinaryDataExtensions { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
