namespace POSGkSwaggerModel
{
    /// <summary>
    /// ExternalLineItemData &lt;p&gt;Manual line item creation with external data.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceTransactionExternalLineItemData	{
        /// <summary>
        /// &lt;p&gt;The pos item ID - IdentityAlphaNumeric40.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The pos item ID - IdentityAlphaNumeric40.&lt;/p&gt;</value>
        public string posItemID { get; init; }
        /// <summary>
        /// &lt;p&gt;The item ID - IdentityUUID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The item ID - IdentityUUID.&lt;/p&gt;</value>
        public string itemID { get; init; }
        /// <summary>
        /// &lt;p&gt;The pos department ID - IdentityAlphaNumeric40.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The pos department ID - IdentityAlphaNumeric40.&lt;/p&gt;</value>
        public string posDepartmentID { get; init; }
        /// <summary>
        /// &lt;p&gt;The unit of measure code - Code4&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unit of measure code - Code4&lt;/p&gt;</value>
        public string unitOfMeasureCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The item type - Code4&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The item type - Code4&lt;/p&gt;</value>
        public string itemType { get; init; }
        /// <summary>
        /// &lt;p&gt;The regular unit price - MoneyShortRetail&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The regular unit price - MoneyShortRetail&lt;/p&gt;</value>
        public double? regularUnitPrice { get; init; }
        /// <summary>
        /// &lt;p&gt;The number of items the regular price is defined for, i.e. 3 for $1.00&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The number of items the regular price is defined for, i.e. 3 for $1.00&lt;/p&gt;</value>
        public int? regularUnitPriceQuantity { get; init; }
        /// <summary>
        /// &lt;p&gt;The actual unit price - MoneyShortRetail&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The actual unit price - MoneyShortRetail&lt;/p&gt;</value>
        public double? actualUnitPrice { get; init; }
        /// <summary>
        /// &lt;p&gt;The number of items the actual price is defined for, i.e. 3 for $1.00&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The number of items the actual price is defined for, i.e. 3 for $1.00&lt;/p&gt;</value>
        public int? actualUnitPriceQuantity { get; init; }
        /// <summary>
        /// &lt;p&gt;The quantity - QuantityIntegerGK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The quantity - QuantityIntegerGK&lt;/p&gt;</value>
        public int? quantity { get; init; }
        /// <summary>
        /// &lt;p&gt;The units - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The units - Quantity&lt;/p&gt;</value>
        public double? units { get; init; }
        /// <summary>
        /// &lt;p&gt;The quantity input method - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The quantity input method - Code2&lt;/p&gt;</value>
        public string quantityInputMethod { get; init; }
        /// <summary>
        /// &lt;p&gt;The length - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The length - Quantity&lt;/p&gt;</value>
        public double? length { get; init; }
        /// <summary>
        /// &lt;p&gt;The width - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The width - Quantity&lt;/p&gt;</value>
        public double? width { get; init; }
        /// <summary>
        /// &lt;p&gt;The height - Quantity&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The height - Quantity&lt;/p&gt;</value>
        public double? height { get; init; }
        /// <summary>
        /// &lt;p&gt;The receipt text - NNameGK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The receipt text - NNameGK&lt;/p&gt;</value>
        public string receiptText { get; init; }
        /// <summary>
        /// &lt;p&gt;The receipt description - NDescriptionShortGK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The receipt description - NDescriptionShortGK&lt;/p&gt;</value>
        public string receiptDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;The wic flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The wic flag - BIT&lt;/p&gt;</value>
        public bool? wicFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The allow food stamp flag -&amp;gt; BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The allow food stamp flag -&amp;gt; BIT&lt;/p&gt;</value>
        public bool? allowFoodStampFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The registration number - DescriptionShort&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The registration number - DescriptionShort&lt;/p&gt;</value>
        public string registrationNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;The discount flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The discount flag - BIT&lt;/p&gt;</value>
        public bool? discountFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The frequent shopper points eligibility flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The frequent shopper points eligibility flag - BIT&lt;/p&gt;</value>
        public bool? frequentShopperPointsEligibilityFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The discount type code - VARCHAR(1)&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The discount type code - VARCHAR(1)&lt;/p&gt;</value>
        public string discountTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The price change type code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The price change type code - Code2&lt;/p&gt;</value>
        public string priceChangeTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The price type code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The price type code - Code2&lt;/p&gt;</value>
        public string priceTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The not considered by loyalty engine flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The not considered by loyalty engine flag - BIT&lt;/p&gt;</value>
        public bool? notConsideredByLoyaltyEngineFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The merchandise hierarchy group name - Name&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The merchandise hierarchy group name - Name&lt;/p&gt;</value>
        public string merchandiseHierarchyGroupName { get; init; }
        /// <summary>
        /// &lt;p&gt;The merchandise hierarchy group description - DescriptionShort&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The merchandise hierarchy group description - DescriptionShort&lt;/p&gt;</value>
        public string merchandiseHierarchyGroupDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;The PosUOMItemDO class code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The PosUOMItemDO class code.&lt;/p&gt;</value>
        public string itemClassCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The prohibit tax exempt flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The prohibit tax exempt flag - BIT&lt;/p&gt;</value>
        public bool? prohibitTaxExemptFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The prohibit return flag - BIT&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The prohibit return flag - BIT&lt;/p&gt;</value>
        public bool? prohibitReturnFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The warranty duration - QuantityTransactionCount&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The warranty duration - QuantityTransactionCount&lt;/p&gt;</value>
        public double? warrantyDuration { get; init; }
        /// <summary>
        /// &lt;p&gt;The deposit type code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The deposit type code - Code2&lt;/p&gt;</value>
        public string depositTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The tax exempt code - Code2&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The tax exempt code - Code2&lt;/p&gt;</value>
        public string taxExemptCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The main POS item ID - IdentityGTIN&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main POS item ID - IdentityGTIN&lt;/p&gt;</value>
        public string mainPOSItemID { get; init; }
        /// <summary>
        /// &lt;p&gt;The main merchandise hierarchy group ID qualifier - Code4&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main merchandise hierarchy group ID qualifier - Code4&lt;/p&gt;</value>
        public string mainMerchandiseHierarchyGroupIDQualifier { get; init; }
        /// <summary>
        /// &lt;p&gt;The main merchandise hierarchy group ID - IdentityAlphaNumeric40&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main merchandise hierarchy group ID - IdentityAlphaNumeric40&lt;/p&gt;</value>
        public string mainMerchandiseHierarchyGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;The tax group ID - Code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The tax group ID - Code&lt;/p&gt;</value>
        public string taxGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;The tare ount - Quantity16_3GK&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The tare ount - Quantity16_3GK&lt;/p&gt;</value>
        public double? tareCount { get; init; }
        /// <summary>
        /// &lt;p&gt;The sale return line item characteristic list - SaleReturnLineItemCharacteristic[0..*]&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The sale return line item characteristic list - SaleReturnLineItemCharacteristic[0..*]&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceTransactionSaleReturnLineItemCharacteristic> SaleReturnLineItemCharacteristicList { get; init; }
        /// <summary>
        /// &lt;p&gt;The sale return line item merchandise hierarchy group list - SaleReturnLineItemMerchandiseHierarchyGroup[0..*]&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The sale return line item merchandise hierarchy group list - SaleReturnLineItemMerchandiseHierarchyGroup[0..*]&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceTransactionSaleReturnLineItemMerchandiseHierarchyGroup> SaleReturnLineItemMerchandiseHierarchyGroupList { get; init; }
        /// <summary>
        /// &lt;p&gt;The retail transaction line item I18N text list - RetailTransactionLineItemI18NText[0..*]&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The retail transaction line item I18N text list - RetailTransactionLineItemI18NText[0..*]&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceTransactionRetailTransactionLineItemI18NText> RetailTransactionLineItemI18NTextList { get; init; }
        /// <summary>
        /// &lt;p&gt;The serialized unit modifer - SerializedUnitModifer&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The serialized unit modifer - SerializedUnitModifer&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionserializedUnitModifer serializedUnitModifer { get; init; }
        /// <summary>
        /// &lt;p&gt;The sale return line item sales order - SaleReturnLineItemSalesOrder&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The sale return line item sales order - SaleReturnLineItemSalesOrder&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceTransactionsaleReturnLineItemSalesOrder saleReturnLineItemSalesOrder { get; init; }
        /// <summary>
        /// &lt;p&gt;The reason code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The reason code&lt;/p&gt;</value>
        public string reasonCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The reason code group code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The reason code group code&lt;/p&gt;</value>
        public string reasonCodeGroupCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The reason description&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The reason description&lt;/p&gt;</value>
        public string reasonDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;The retail transaction line item additional parameter list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The retail transaction line item additional parameter list&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceTransactionRetailTransactionLineItemAdditionalParameter> RetailTransactionLineItemAdditionalParameterList { get; init; }
        /// <summary>
        /// &lt;p&gt;The retail price modifier list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The retail price modifier list&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppServicesTransactionExternalRetailPriceModifier> RetailPriceModifierList { get; init; }
        /// <summary>
        /// &lt;p&gt;The line item extension list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The line item extension list&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppServicesTransactionLineItemExtension> LineItemExtensionList { get; init; }
        /// <summary>
        /// &lt;p&gt;The print additional line item text line list&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The print additional line item text line list&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppServicesTransactionPrintAdditionalLineItemTextLine> PrintAdditionalLineItemTextLineList { get; init; }
	}
}
