namespace POSGkSwaggerModel
{
    /// <summary>
    /// PrintOutTransactionsRequest &lt;p&gt;Request object to search for printout transactions.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceTransactionPrintOutTransactionsRequest	{
        /// <summary>
        /// &lt;p&gt;A flag to indicate that only transaction of type code &#39;RETAIL&#39; and category code &#39;SALE&#39; should be searched.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate that only transaction of type code &#39;RETAIL&#39; and category code &#39;SALE&#39; should be searched.&lt;/p&gt;</value>
        public bool? onlySalesReprintable { get; init; }
        /// <summary>
        /// &lt;p&gt;The transaction type code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The transaction type code.&lt;/p&gt;</value>
        public string transactionTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The retail transaction type code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The retail transaction type code.&lt;/p&gt;</value>
        public string retailTransactionTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate that only transactions that are not voided should be searched.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate that only transactions that are not voided should be searched.&lt;/p&gt;</value>
        public bool? transactionIsNotVoided { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate that only transactions that are cancelled should be searched.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate that only transactions that are cancelled should be searched.&lt;/p&gt;</value>
        public bool? cancelledFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate that only transactions that are suspended should be searched.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate that only transactions that are suspended should be searched.&lt;/p&gt;</value>
        public bool? suspendedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The workstation identifier.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The workstation identifier.&lt;/p&gt;</value>
        public string workstationID { get; init; }
        /// <summary>
        /// Gets or Sets EndWorkstationID
        /// </summary>
        public string endWorkstationID { get; init; }
        /// <summary>
        /// &lt;p&gt;The business unit group identifier.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The business unit group identifier.&lt;/p&gt;</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate that only transactions that are printable should be searched.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate that only transactions that are printable should be searched.&lt;/p&gt;</value>
        public bool? receiptIsPrintable { get; init; }
        /// <summary>
        /// &lt;p&gt;Limits the number of found receipts to the given value.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Limits the number of found receipts to the given value.&lt;/p&gt;</value>
        public int? maxReceiptCount { get; init; }
        /// <summary>
        /// &lt;p&gt;The begin date timestamp greater or equals (as part of the search criteria).&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;The begin date timestamp greater or equals (as part of the search criteria).&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string beginDateTimestampGreaterOrEquals { get; init; }
        /// <summary>
        /// &lt;p&gt;A list of parent customer identifiers.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A list of parent customer identifiers.&lt;/p&gt;</value>
        public List<string> ParentCustomerIds { get; init; }
        /// <summary>
        /// &lt;p&gt;A list of customer identifiers.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A list of customer identifiers.&lt;/p&gt;</value>
        public List<string> CustomerIds { get; init; }
        /// <summary>
        /// &lt;p&gt;A card type which has to be used for the customer identification.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A card type which has to be used for the customer identification.&lt;/p&gt;</value>
        public string customerAddressTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
