namespace POSGkSwaggerModel
{
    /// <summary>
    /// ItemSellingRuleSO &lt;p&gt;This object is a set of rules used for item selling.&lt;br /&gt; The rules can be referred from the item object and merchandise hierarchy group object.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;The fields of this rule object are imported directly on the item / MHG, but saved as a separate domain object to save storage place.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterData_Item.xml from the element Item.UOMItem.ItemSellingRule.&lt;br /&gt; Import from masterData_BusinessUnit.xml from the element BusinessUnit.MerchandiseHierarchyGroupDetail.ItemSellingRule: DiscountFlag, BonusPointsFlag and NegativePositionFlag.&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareSweeSesApiServerMdItemSellingRuleDtoSoItemSellingRuleSO	{
        /// <summary>
        /// &lt;p&gt;Type code for controlling the quantity input&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type code for controlling the quantity input&lt;br /&gt;&lt;/p&gt;</value>
        public quantityInputTypeCodeEnum quantityInputTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines how the input of quantity is done on POS&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how the input of quantity is done on POS&lt;br /&gt;&lt;/p&gt;</value>
        public quantityInputMethodEnum quantityInputMethod { get; init; }
        /// <summary>
        /// &lt;p&gt;Type code for the manual price change.&lt;br /&gt; Values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00 &#x3D; price 0.00 not allowed LIMITED,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; price 0.00 allowed - POSSIBLE,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02 &#x3D; no price change allowed - PROHIBITED&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type code for the manual price change.&lt;br /&gt; Values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00 &#x3D; price 0.00 not allowed LIMITED,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; price 0.00 allowed - POSSIBLE,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02 &#x3D; no price change allowed - PROHIBITED&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public priceChangeTypeCodeEnum priceChangeTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Bar code handling method&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Bar code handling method&lt;br /&gt;&lt;/p&gt;</value>
        public barCodeHandlingMethodEnum barCodeHandlingMethod { get; init; }
        /// <summary>
        /// &lt;p&gt;A unique system assigned identifier for the item selling rule.&lt;br /&gt; Generated, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A unique system assigned identifier for the item selling rule.&lt;br /&gt; Generated, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string itemSellingRuleId { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to denote that the retail price is to be manually entered when this item is sold.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to denote that the retail price is to be manually entered when this item is sold.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? priceEntryRequiredFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to denote whether or not this item may be returned. (Eg: freezer or chilled merchandise)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to denote whether or not this item may be returned. (Eg: freezer or chilled merchandise)&lt;br /&gt;&lt;/p&gt;</value>
        public bool? prohibitReturnFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate whether food stamps can be tendered for this item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate whether food stamps can be tendered for this item.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? allowFoodStampFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag denoting if this item is allowed in a WIC transaction.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag denoting if this item is allowed in a WIC transaction.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? wicFlag { get; init; }
        /// <summary>
        /// Gets or Sets FsaCode
        /// </summary>
        public string fsaCode { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate if the item can be delivered to the customer.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate if the item can be delivered to the customer.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? deliveryStockAssortmentFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether a prepayment/downpayment position should be retained when an order of the item is voided (e.g. the prepayment could be retained if the order of a special measured item is voided)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether a prepayment/downpayment position should be retained when an order of the item is voided (e.g. the prepayment could be retained if the order of a special measured item is voided)&lt;br /&gt;&lt;/p&gt;</value>
        public bool? retainPrepaymentFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate if the customer may take an item home to test it&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate if the customer may take an item home to test it&lt;br /&gt;&lt;/p&gt;</value>
        public bool? takeAwayAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines if the registration of the item requires a serial number input&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines if the registration of the item requires a serial number input&lt;br /&gt;&lt;/p&gt;</value>
        public bool? serialNumberRequiredFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to denote if no tax exemption is allowed for the item. True &#x3D; no tax exemption allowed.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to denote if no tax exemption is allowed for the item. True &#x3D; no tax exemption allowed.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? taxExemptProbihitedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate that the retail store is authorized to stock this particular item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate that the retail store is authorized to stock this particular item.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? authorisedForSaleFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate whether this item can be discounted.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate whether this item can be discounted.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? discountFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether bonus points are allowed for the item&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether bonus points are allowed for the item&lt;br /&gt;&lt;/p&gt;</value>
        public bool? bonusPointsFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Date when selling of the item becomes effective&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Date when selling of the item becomes effective&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string sellingEffectiveDate { get; init; }
        /// <summary>
        /// &lt;p&gt;Last date when the item is available for sale&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Last date when the item is available for sale&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string sellingExpirationDate { get; init; }
        /// <summary>
        /// &lt;p&gt;If this flag is set to true, automatically a negative position is created when registering this item&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If this flag is set to true, automatically a negative position is created when registering this item&lt;br /&gt;&lt;/p&gt;</value>
        public bool? negativePositionFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the price is to be hided (not printed) on the receipt and to be hided (not shown)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the price is to be hided (not printed) on the receipt and to be hided (not shown)&lt;br /&gt;&lt;/p&gt;</value>
        public bool? hidePriceFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this item is to be shown on the customer display&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this item is to be shown on the customer display&lt;br /&gt;&lt;/p&gt;</value>
        public bool? showItemOnCustomerDisplayFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to denote that the weight is to be registered when this item is sold&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to denote that the weight is to be registered when this item is sold&lt;br /&gt;&lt;/p&gt;</value>
        public bool? weightEntryRequiredFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether it is possible to register a price on scales&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether it is possible to register a price on scales&lt;br /&gt;&lt;/p&gt;</value>
        public bool? priceEntryOnScalesAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Flag AllowLayawayFlag defines if an item is allowed for Layaway or not.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Flag AllowLayawayFlag defines if an item is allowed for Layaway or not.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? allowLayawayFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Flag LayawayDiscountFlag defines if promotions are allowed for the &#39;Layaway&#39; item.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Flag LayawayDiscountFlag defines if promotions are allowed for the &#39;Layaway&#39; item.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? layawayDiscountFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM30 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM01 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM17 { get; init; }
	}
}
