﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Linq;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Adaptador para manejar la lógica de Restriccion de edad
    /// </summary>
    public class AdaptadorAddCustomerBirthdateRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:AddCustomerBirthdate";
        public string NombreElementoXMLDatos { get; set; } = "./AddCustomerBirthdateRequest";
        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            XmlSerializer serializer = new XmlSerializer(typeof(AddCustomerBirthdateRequest));

            AddCustomerBirthdateRequest dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);

            dto = (AddCustomerBirthdateRequest)serializer.Deserialize(elemento);

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            dto.IdSesion = idSesion;
            dto.TipoMensaje = tipoMensaje;
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");
            dto.CustomerBirthdate = Util.LeeStringEnNodo(nodo, "./CustomerBirthdate");

            return dto;

        }
        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        /// 
        public IAdaptadorDTO CreaCopia()
        { 
            return (AdaptadorAddCustomerBirthdateRequest)this.MemberwiseClone();
        }
    }
}
