﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Adaptador para manejar la lógica de de agregar cliente
    /// </summary>
    public class AdaptadorAddCustomerRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:AddCustomer";
        public string NombreElementoXMLDatos { get; set; } = "./AddCustomerRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            XmlSerializer serializer = new XmlSerializer(typeof(AddCustomerRequest));

            AddCustomerRequest dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);

            dto = (AddCustomerRequest)serializer.Deserialize(elemento);

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            dto.IdSesion = idSesion;
            dto.TipoMensaje = tipoMensaje;
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");
            //if(dto.CustomerIdentifier.CustomerID > 0)
            dto.CustomerIdentifier.CustomerID = Util.LeeStringEnNodo(nodo, ".//CustomerID");

            return dto;
        }

        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        /// 
        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorAddCustomerRequest)this.MemberwiseClone();
        }
    }
}
