﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Clase para crear el adaptador de agregar articulo
    /// </summary>
    public class AdaptadorAddItemRequest : IAdaptadorDTO
    { 

        public string Referencia { get; set; } = "scsns:AddItem";
        public string NombreElementoXMLDatos { get; set; } = "./AddItemRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            XmlSerializer serializer = new XmlSerializer(typeof(AddItemRequestDTO));
            AddItemRequestDTO dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);
            dto = (AddItemRequestDTO)serializer.Deserialize(elemento);
            

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            dto.IdSesion = idSesion;
            dto.TipoMensaje =  tipoMensaje;
            //Cambio: LeeIntEnNodo por LeeStringEnNodo
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");

            if(dto.ItemIdentifier.BarCode != null)
                dto.ItemIdentifier.BarCode.ScanDataLabel = Util.LeeLongEnNodo(nodo, ".//ScanDataLabel");
            if(dto.ItemIdentifier.Quantity > 0)
                dto.ItemIdentifier.Quantity = Util.LeeIntEnNodo(nodo, ".//Quantity");
            if( dto.ItemIdentifier.VoidFlag == true)
                dto.ItemIdentifier.VoidFlag = Util.LeeBoolEnNodo(nodo, ".//VoidFlag");
            if (dto.ItemIdentifier.ScaleWeight > 0)
                dto.ItemIdentifier.ScaleWeight = Util.LeeLongEnNodo(nodo, ".//ScaleWeight");
            if(dto.ItemIdentifier.KeyedItemID > 0)
                dto.ItemIdentifier.KeyedItemID = Util.LeeLongEnNodo(nodo, ".//KeyedItemID");

            return dto;
        }

        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorAddItemRequest)this.MemberwiseClone();
        }
    }
}
