﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;
using static EvaPOS_API_FRAME.DTO.RemoveReceiptLinesDTO;

namespace EvaPOS_API_FRAME.Adaptadores
{
    /// <summary>
    /// Clase para crear el adaptador Remover Lineas de CHEC
    /// </summary>
    public class AdaptadorRemoveReceiptLines : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:RemoveReceiptLines";
        public string NombreElementoXMLDatos { get; set; } = "./RemoveReceiptLinesRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);

            XmlSerializer serializer = new XmlSerializer(typeof(RemoveReceiptLinesRequest));

            RemoveReceiptLinesRequest dto;
            XmlNodeReader elemento = new XmlNodeReader(nodo);

            dto = (RemoveReceiptLinesRequest)serializer.Deserialize(elemento);

            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            dto.IdSesion = idSesion;
            dto.TipoMensaje = tipoMensaje;
            dto.RequestID = Util.LeeIntEnNodo(nodo, "./RequestID");

            return dto;
        }

        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorRemoveReceiptLines)this.MemberwiseClone();
        }
    }
}
