﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using GatewaySCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.Adaptadores
{ 
    public class AdaptadorSignOffRequest : IAdaptadorDTO
    {
        public string Referencia { get; set; } = "scsns:SignOff";
        public string NombreElementoXMLDatos { get; set; } = "./SignOffRequest";

        public DTOBase ObtieneDTO(int idSesion, TipoMensaje tipoMensaje, XmlElement docXml)
        {
            XmlNode? nodo = docXml.SelectSingleNode(NombreElementoXMLDatos);
            if (nodo == null)
                throw new Exception($"Elemento '{NombreElementoXMLDatos}'.");
            var dto = new SignOffRequestDTO(idSesion, tipoMensaje);
            //Cambio: LeeIntEnNodo por LeeStringEnNodo
            dto.OperadorID = Util.LeeStringEnNodo(nodo, "./OperatorID");
            return dto;
        }
   

        /// <summary>
        /// Retorna una "shallow copy" del objeto.
        /// </summary>
        public IAdaptadorDTO CreaCopia()
        {
            return (AdaptadorSignOffRequest)this.MemberwiseClone();
        }
    }
}
