using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using RestSharp;
using RestSharp.Authenticators;
using SCOGateway.POSGk;
using GatewaySCO;

namespace SCOGateway.POSGkPruebas
{
    public class InitializeRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:Initialize";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public InitializeRequestDTO Request { get; private set; }

        /// <summary>
        /// Url servicio autenticación Gk.
        /// </summary>
        public const string UrlAuthenticate = ConstantesGK.UrlBaseMaqueta + "/com.gk_software.pos.api.service.security.AuthenticationService/authenticate";

        /// <summary>
        /// Procesa y responde InitializeRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            int terminalNumber = Request.TerminalNumber;
            Log.Debug("Cmd InitializeRequestCmd ejecutado - Gk pruebas. Request id: {id}, terminal: {terminal}, recovery: {recovery}", Request.OperatorID, Request.TerminalNumber, Request.Recovery);
            // Contactar Smart POS Gk.
            var client = new RestClient(UrlAuthenticate);
            var request = new RestRequest(UrlAuthenticate, Method.Post);
            var datosAutenticacion = new AutenticationReq { LoginName = "usuario", Password = "12345" };
            request.AddJsonBody(datosAutenticacion);
            
            // Ejecuta invocación sincrónica, deserializando respuesta según el tipo indicado en la invocación del Post<T>.
            var autenticacionResp = client.Post<AuthenticateResp>(request) ?? throw new ApplicationException("Servicio POST 'Authenticate' retorna nulos.");
            Log.Debug($"GkPruebas: Autenticate - POST - response {autenticacionResp}");

            // Salvar el token de autenticación y demás datos.
            //Entorno<EntornoGK>.Instancia.getDatos().RealmId = autenticacionResp.RealmId;
            //Entorno<EntornoGK>.Instancia.getDatos().ExpirationCountDays = autenticacionResp.ExpirationCountDays;

            // Respuestas a SCO.
            var posbcStatus1 = new POSBCStatusEvent(1, TipoMensaje.Event, "INFO", "CONNECTING_TO_POS", "Connecting to POS system");
            var posbcStatus2 = new POSBCStatusEvent(1, TipoMensaje.Event, "INFO", "CONNECTED_TO_POS", "Connected to POS system");
            var posbcStatus3 = new POSBCStatusEvent(1, TipoMensaje.Event, "INFO", "POS_RESOURCES_INITIALIZED", "POS Resources Initialized");
            var inicializacionOk = new InitializeResponse(1, TipoMensaje.Resp, terminalNumber);
            return (new Respuestas { posbcStatus1, posbcStatus2, posbcStatus3,inicializacionOk });
        }

        public IComando CreaCopia()
        {
            return (InitializeRequestCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase initializeRequestDTO)
        {
            Request = (InitializeRequestDTO)initializeRequestDTO;
        } 
    }
}