﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.RestriccionEdad;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Comando para la construcción de la logica "Restricción de edad"
    /// </summary>
    public class AddCustomerBirthdateCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:AddCustomerBirthdate";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public AddCustomerBirthdateRequest Request { get; private set; }
        /// <summary>
        /// Procesa y responde AddCustomerBirthdateRequest.
        /// </summary>

        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd AddCustomerBirthdateRequestCmd ejecutado. AddCustomerBirthdateRequest : {AddCustomerBirthdateRequest}", Request.RequestID);
            int requestId = Request.RequestID;
            var addCustomerBirthdate = new AddCustomerBirthdateResponse(1, TipoMensaje.Resp, requestId);

            return (new Respuestas { addCustomerBirthdate });
        }

        public IComando CreaCopia()
        {
            return (AddCustomerBirthdateCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase addCustomerBirthdateRequest)
        {
            Request = (AddCustomerBirthdateRequest)addCustomerBirthdateRequest;
        }

    }
}
