﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.DTO.Intercambio;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.AddCustomer;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    /// <summary>
    /// Comando para agregar un cliente
    /// </summary>
    public class AddCustomerCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:AddCustomer";

        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public AddCustomerRequest Request { get; set; }
        /// <summary>
        /// Procesa y responde AddCustomerRequest.
        /// </summary>
        /// 
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd AddCustomerRequestCmd ejecutado. AddCustomerRequest : {AddCustomerRequest}", Request.RequestID);
            int requestId = Request.RequestID;
            Respuestas respuesta = null;
            AddCustomerResponse addCustomer = null;
            AddCustomerResponseNoEncontrado addCustomerNotFound = null;
            TransactionStatusEvent transactionStatusEvent = null;
            POSReceiptEventHeaderResponse posReceiptEventHeader = null;
            POSReceiptEvent pOSReceiptEvent = null;

            var date = DateTime.Now.ToString("dd/MM/yyyy");
            CultureInfo culture = new CultureInfo("en-US");
            culture.DateTimeFormat.AMDesignator = "AM";
            culture.DateTimeFormat.PMDesignator = "PM";
            var time = DateTime.Now.ToString("hh:mm tt", culture);

            string idCliente = Request.CustomerIdentifier.CustomerID;
                
               transactionStatusEvent = new TransactionStatusEvent(1, TipoMensaje.Event, requestId, "TRANSACTION_START", 1, "regularSale", "sales", date, time);
               pOSReceiptEvent = new POSReceiptEvent(1, TipoMensaje.Event, requestId, "Customer", 0, "Body", requestId, 1, "center", "LineItem", "ItemSale", "Cliente:" + " " + "Brayan", "Add");
               posReceiptEventHeader = new POSReceiptEventHeaderResponse(1, TipoMensaje.Event, requestId);
               addCustomer = new AddCustomerResponse(1, TipoMensaje.Resp, requestId, "123456", "Brayan", 1234);
               respuesta = new Respuestas { transactionStatusEvent, posReceiptEventHeader, pOSReceiptEvent, addCustomer };

               return respuesta;
        }

        public IComando CreaCopia()
        {
            return (AddCustomerCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase addCustomerRequest)
        {
            Request = (AddCustomerRequest)addCustomerRequest;
        }

    }
}
