﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EvaPOS_API_FRAME.DTO.Intercambio;
using System.Collections;
using System.Xml.Linq;
using System.Globalization;
using System.IO;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Procesa solicitudes del primer item agregado.
    /// </summary>
    public class AddItemRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:AddItem";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public AddItemRequestDTO Request { get; private set; }

        /// <summary>
        /// Procesa y responde ReportStatusEventsRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd AddItemRequestDTO ejecutado. AddItemRequest : {AddItemRequest}", Request.RequestID);
            //int requestIdGuardado = RequestIdGuardado();
            POSBCStatusEvent posbcStatus = null;
            TransactionStatusEvent transactionStatusEvent = null;
            POSReceiptEventHeaderResponse posReceiptEventHeader = null;
            POSReceiptEvent pOSReceiptEvent = null;
            TotalsEventResponse totalEvent = null;
            AddItemResponse itemResponse = null;
            //Variables para manejar las respuestas de error - (item con peso, no se encuentra el item,item requiere cantidad)
            AddItemResponseError addItemResponseError = null;
            Respuestas respuesta = null;
            Venta venta = null;
            //Variables del adaptador de entrada - addItem
            int requestId = Request.RequestID;
            long barCode = 0;
            int quantity = Request.ItemIdentifier.Quantity == 0 ? 1 : Request.ItemIdentifier.Quantity;
            bool cancelItem = Request.ItemIdentifier.VoidFlag;
            double peso = Request.ItemIdentifier.ScaleWeight;
            //Logica para validar el valor del codigo de barras
            //Si es un item de busqueda o imagen, trae el valor KeyedItemID, si es escaneado trae barcode
            if (Request.ItemIdentifier.BarCode != null)
                barCode = Request.ItemIdentifier.BarCode.ScanDataLabel;
            else
                barCode = Request.ItemIdentifier.KeyedItemID;

            string tomarNombreCorto = "";
            //Valores que se mandan en chec
            var date = DateTime.Now.ToString("dd/MM/yyyy");
            CultureInfo culture = new CultureInfo("en-US");
            culture.DateTimeFormat.AMDesignator = "AM";
            culture.DateTimeFormat.PMDesignator = "PM";
            var time = DateTime.Now.ToString("hh:mm tt", culture);

            transactionStatusEvent = new TransactionStatusEvent(1, TipoMensaje.Event, requestId, "TRANSACTION_START", 1, "regularSale", "sales", date, time);
            pOSReceiptEvent = new POSReceiptEvent(1, TipoMensaje.Event, requestId, "Customer", 0, "Body", requestId, 1, "center", "LineItem", "ItemSale", "1234" + "   " + "Producto" + "      " + "1" + "      " + 3200, "Add");
            posReceiptEventHeader = new POSReceiptEventHeaderResponse(1, TipoMensaje.Event, requestId);
            totalEvent = new TotalsEventResponse(1, TipoMensaje.Event, requestId, "3200", "3200", "3200", "3200", "0.00", "0.00", "0.00", "0.00", "0.00", 1, 0, "0.00", "0.00");
            itemResponse = new AddItemResponse(1, TipoMensaje.Resp, requestId, tomarNombreCorto, "false", "false", "true", "1234", "ScannedItemCode", "3200", 1, "3200", 0, "0.00", 0, 1, 0, "unit", "false", 0, "false", "false", "true", "true");
            respuesta = new Respuestas { transactionStatusEvent, posReceiptEventHeader, pOSReceiptEvent, totalEvent, itemResponse };

            return (respuesta);
        }


        public IComando CreaCopia()
        {
            return (AddItemRequestCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase addItemRequestDTO)
        {
            Request = (AddItemRequestDTO)addItemRequestDTO;
        }

    }
}
