﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Procesa el salto del empaque del producto
    /// </summary>
    public class AddReceiptLinesRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:AddReceiptLines";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public AddReceiptLinesRequest Request { get; private set; }
        /// <summary>
        /// Procesa y responde ReportStatusEventsRequest.
        /// </summary>

        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd AddReceiptLinesRequestCmd ejecutado. AddReceiptLinesRequest : {AddReceiptLinesRequest}", Request.RequestID);
            int requestId = Request.RequestID;
            var addReceiptLinesResponse =new AddReceiptLinesResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { addReceiptLinesResponse });
        }


        public IComando CreaCopia()
        {
            return (AddReceiptLinesRequestCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase addReceiptLinesRequest)
        {
            Request = (AddReceiptLinesRequest)addReceiptLinesRequest;
        }

    }
}
