﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.DTO.Intercambio;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.CancelDatafono;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using System.Net.Http;
using System.IO;
using System.Text;
using System.Security.Cryptography;
using EvaPOS_API_FRAME.RespuestasXML.Printer;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Procesa solicitudes del pago con tarjeta de debito
    /// </summary>
    public class AddTenderDebitCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:AddTender";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public AddTenderRequest Request { get; private set; }

        /// <summary>
        /// Procesa y responde eventos del pago con tarjeta de debito
        /// </summary>

        public Respuestas Ejecutar()
        {
            //instanciar xml de respuestas
            TransactionStatusEvent transactionStatusEvent = null;
            POSReceiptEventDebit posbcEvent1 = null;
            POSReceiptEvent posbcEvent3 = null;
            POSReceiptEvent posbcEvent4 = null;
            TotalsEventResponse totalEvent = null;
            AddTenderDebitResponse addTender = null;
            AddTenderResponseError cancelActionResponse = null;
            POSBCStatusEventPrinterSingle posbcStatusPrinter = null;

            Log.Debug("Cmd AddTenderDebitDTO ejecutado. AddTenderDebit : {AddTenderDebit}", Request.RequestID);
            int requestId = Request.RequestID;
            ReportStatusEventsRequestCmd reportStatusEventsRequestCmd = new ReportStatusEventsRequestCmd();
            AddItemRequestCmd addItemRequestCmd = new AddItemRequestCmd();
            Respuestas respuestasChec = null;

           

            // Ingresamos al Datafono y realizamos la transaccion
            var date = DateTime.Now.ToString("MM/dd/yyyy");
            //GuardarId(requestId);
            CultureInfo culture = new CultureInfo("en-US");
            culture.DateTimeFormat.AMDesignator = "AM";
            culture.DateTimeFormat.PMDesignator = "PM";
            var time = DateTime.Now.ToString("hh:mm tt", culture);

            
            posbcEvent3 = new POSReceiptEvent(1, TipoMensaje.Event, requestId, "Customer", 0, "Trailer", requestId, 1, "center", "Trailer", "WorkstationInfo", date + time, "Add");
            posbcEvent4 = new POSReceiptEvent(1, TipoMensaje.Event, requestId, "Customer", 0, "Trailer", requestId, 1, "center", "Trailer", "WorkstationInfo", date + time, "Add");
            posbcEvent1 = new POSReceiptEventDebit(1, TipoMensaje.Event, requestId, date + time);
            totalEvent = new TotalsEventResponse(1, TipoMensaje.Event, requestId, "3200", "3200", "3200", "3200", "0.00", "0.00", "0.00", "0.00", "0.00", 5200, 0, "0.00", "0.00");
            transactionStatusEvent = new TransactionStatusEvent(1, TipoMensaje.Event, requestId, "TRANSACTION_END", 1, "regularSale", "sales", date, time);

            addTender = new AddTenderDebitResponse(1, TipoMensaje.Resp, requestId, "false", "false", "false", "3200", "debit", "true", "9999", -1, 00350383, 350384, 0, "false", "approved", "false");
            respuestasChec = new Respuestas { posbcEvent3, posbcEvent4, posbcEvent1, totalEvent, transactionStatusEvent, addTender };

            return respuestasChec;
        }

        public IComando CreaCopia()
        {
            return (AddTenderDebitCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase AddTenderRequestDebitDTO)
        {
            Request = (AddTenderRequest)AddTenderRequestDebitDTO;
        }

    }

}

