﻿using EvaPOS_API_FRAME.RespuestasXML.CancelDatafono;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static EvaPOS_API_FRAME.DTO.CancelActionDTO;

namespace EvaPOS_API_FRAME.Comandos
{
    /// <summary>
    /// Comando para cancelar acción en el Datafóno
    /// </summary>
    public class CancelActionCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:CancelAction";
        /// <summary>
        /// DTO con la solicitud de referencia.
        /// </summary>
        public CancelActionRequest Request { get; private set; }
        /// <summary>
        /// Procesa y responde el evento Request.
        /// </summary>

        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd CancelActionCmd ejecutado. CancelAction : {CancelActionRequest}", Request.RequestID);
            int requestId = Request.RequestID;
            CancelActionResponse cancelActionResponse = new CancelActionResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { cancelActionResponse });

        }

        public IComando CreaCopia()
        {
            return (CancelActionCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase CancelActionDTO)
        {
            Request = (CancelActionRequest)CancelActionDTO;
        }

    }
}
