﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EvaPOS_API_FRAME.RespuestasXML;
using System.IO;
using EvaPOS_API_FRAME.DTO.Intercambio;
using EvaPOS_API_FRAME.RespuestasXML.Printer;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Procesa solicitudes de ReportStatusEventsRequest.
    /// </summary>
    public class ReportStatusEventsRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:ReportStatusEvents";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public ReportStatusEventsRequestDTO Request { get; private set; }

        /// <summary>
        /// Procesa y responde ReportStatusEventsRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd ReportStatusEventsRequestDTO ejecutado. ReportStatusEventsRequest : {ReportStatusEventsRequest}", Request.RequestID);
            POSBCStatusEventPrinterSingle posbcStatusPrinter = null;
            int requestId = Request.RequestID;

            var ReportStatusEventsResponse = new ReportStatusEventsResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { ReportStatusEventsResponse });
        }

        public IComando CreaCopia()
        {
            return (ReportStatusEventsRequestCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase reportStatusEventsRequestDTO)
        {
            Request = (ReportStatusEventsRequestDTO)reportStatusEventsRequestDTO;
        }

    }
}
