﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPOS_API_FRAME.RespuestasXML.Printer;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Procesa solicitudes del SignOff
    /// </summary>
    public class SignOffResponseCmd: IComando
    {
       
        public string Referencia { get; set; } = "scsns:SignOff";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        
        public SignOffRequestDTO Request { get; private set; }

        /// <summary>
        /// Procesa y responde SignOffRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd SignOffRequestDTO ejecutado. SignOffRequest : {SignOffRequest}", Request.OperadorID);
            string requestId = Request.OperadorID;
            var signOffResponse = new SignOffResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { signOffResponse });
        }


        public IComando CreaCopia()
        {
            return (SignOffResponseCmd)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase signOffResponseDTO)
        {
            Request = (SignOffRequestDTO)signOffResponseDTO;
        }
    }
}
