﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML.Suspend;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Comando para suspender transacción
    /// </summary>
    public class SuspendTransactionRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:Suspend";

        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public SuspendTransactionRequest Request { get; private set; }
        /// <summary>
        /// Procesa y responde SuspendTransactionRequest.
        /// </summary>
        /// 
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd SuspendTransactionRequesttCmd ejecutado. SuspendTransactionRequest : {SuspendTransactionRequest}", Request.RequestID);
            int requestId = Request.RequestID;

            var suspendTransaction = new SuspendTransactionResponseError(1, TipoMensaje.Resp, requestId, "No se puede realizar la suspension", "APPLICATION_NOT_IN_PROPER_STATE: TRANSACTION_NOT_ACTIVE");
            return (new Respuestas { suspendTransaction });
        }

        public IComando CreaCopia()
        {
            return (SuspendTransactionRequestCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase suspendTransactionRequest)
        {
            Request = (SuspendTransactionRequest)suspendTransactionRequest;
        }
    }
}
