﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML.TerminateLane;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using EvaPOS_API_FRAME.RespuestasXML.Printer;

namespace EvaPOS_API_FRAME.Comandos
{
    /// <summary>
    /// Comando para cerrar la lane   
    /// </summary>
    public class TerminateRequestCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:Terminate";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public TerminateRequestDTO Destroy { get; private set; }

        /// <summary>
        /// Procesa y responde el evento Terminar.
        /// </summary>
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd TerminateRequestDTO ejecutado. TerminateRequest : {TerminateRequest}", Destroy.DestroySession);
            var requestId = Destroy.DestroySession;
            TerminateResponse terminateResponse = new TerminateResponse(1, TipoMensaje.Resp, requestId);
            return (new Respuestas { terminateResponse });
        }


        public IComando CreaCopia()
        {
            return (TerminateRequestCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase terminateRequest)
        {
            Destroy = (TerminateRequestDTO)terminateRequest;
        }

    }
}
