﻿using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML.CancelTransaction;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.Comandos
{
    ///<summary>
    /// Comando para cancelar una transacción
    /// </summary>
    public class VoidTransactionCmd : IComando
    {
        public string Referencia { get; set; } = "scsns:VoidTransaction";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public VoidTransactionDTO Request { get; private set; }
        /// <summary>
        /// Procesa y responde VoidTransactionRequest.
        /// </summary>

        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd VoidTransactionDTO ejecutado. VoidTransactionRequest : {VoidTransactionRequest}", Request.RequestID);
            int RequestId = Request.RequestID;
            VoidTransactionResponse voidTransactionResponse = new VoidTransactionResponse(1, TipoMensaje.Resp, RequestId);
            return (new Respuestas { voidTransactionResponse });
            
        }

        public IComando CreaCopia()
        {
            return (VoidTransactionCmd)this.MemberwiseClone();
        }
        public void CargaDTO(DTOBase voidTransactionDTO)
        {
            Request = (VoidTransactionDTO)voidTransactionDTO;
        }
      
    }
}
