﻿using EvaPOS_API_FRAME.DTO.Intercambio;
using EvaPOS_API_FRAME.DTO;
using EvaPOS_API_FRAME.RespuestasXML;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using Serilog;
using System.Globalization;
using RestSharp;
using gatewayGK.POSGk;
using System.Text.Json;
using Newtonsoft.Json.Linq;
using GatewaySCO;

namespace gatewayGK.ComandosGk
{
    ///<summary>
    /// Procesa solicitudes del primer item agregado.
    /// </summary>
    // TODO - unificar uso de libreria json: using System.Text.Json OR using Newtonsoft.Json.Linq;
    //
    public class AddItemRequestCmdGk2 : IComando
    {
        public string Referencia { get; set; } = "scsns:AddItem";
        /// <summary>
        /// DTO con solicitud.
        /// </summary>
        public AddItemRequestDTO Request { get; private set; }

        /// <summary>
        /// Url servicio autenticación Gk.
        /// </summary>
        private string _urlRegisterItem = Entorno<EntornoGK>.Instancia.get().UrlBase
            + "/com.gk_software.pos.api.service.transaction.LineItemService/registerLineItem";

        /// <summary>
        /// Procesa agregar item y responde ReportStatusEventsRequest.
        /// </summary>
        public Respuestas Ejecutar()
        {
            Log.Debug("Cmd AddItemRequestDTO ejecutado. AddItemRequest : {AddItemRequest}", Request.RequestID);

            //int requestIdGuardado = RequestIdGuardado();
            POSBCStatusEvent posbcStatus = null;
            TransactionStatusEvent transactionStatusEvent = null;
            POSReceiptEventHeaderResponse posReceiptEventHeader = null;
            POSReceiptEvent pOSReceiptEvent = null;
            TotalsEventResponse totalEvent = null;
            AddItemResponse itemResponse = null;
            //Variables para manejar las respuestas de error - (item con peso, no se encuentra el item,item requiere cantidad)
            AddItemResponseError addItemResponseError = null;
            Respuestas respuesta = null;
            Venta venta = null;
            //Variables del adaptador de entrada - addItem
            int requestId = Request.RequestID;
            long barCode = 0;
            int quantity = Request.ItemIdentifier.Quantity == 0 ? 1 : Request.ItemIdentifier.Quantity;
            bool cancelItem = Request.ItemIdentifier.VoidFlag;
            double peso = Request.ItemIdentifier.ScaleWeight;
            //Logica para validar el valor del codigo de barras
            //Si es un item de busqueda o imagen, trae el valor KeyedItemID, si es escaneado trae barcode
            if (Request.ItemIdentifier.BarCode != null)
                barCode = Request.ItemIdentifier.BarCode.ScanDataLabel;
            else
                barCode = Request.ItemIdentifier.KeyedItemID;

            // --- cliente rest.
            var options = new RestClientOptions()
            {
                // TODO manejar el timeout como un parámetro de configuración.
                MaxTimeout = -1,
                RemoteCertificateValidationCallback = (sender, certificate, chain, sslPolicyErrors) => true
            };
            string sessionId = Entorno<EntornoGK>.Instancia.get().posSessionId;
            string cookieValue = $"sessionid={sessionId}";

            var client = new RestClient(options);
            var request = new RestRequest(_urlRegisterItem, Method.Post);
            request.AddHeader("Accept", "application/json;Format=GK-PLAIN-JSON");
            request.AddHeader("Content-Type", "application/json;Format=GK-PLAIN-JSON");
            request.AddHeader("_pos_session_", sessionId);
            request.AddHeader("Cookie", cookieValue);

            // Record inicializado por nombre de propiedades.
            var operationConfiguration = new operationConfiguration { pricePositionLimit = 10000000 }; // TODO - controlar este valor, como sacarlo del Smart POS.
            var datosItem = new registerLineItemReq
            {
                barcode = barCode.ToString(),
                entryMethodCode = "Keyed",
                operationConfiguration = operationConfiguration
            };
            string json = JsonSerializer.Serialize(datosItem);
            request.AddJsonBody(json);
            Log.Verbose(">> GK registerLineItem - body {json}", json);
            Log.Information(">> GK registerLineItem - posSessionId {posSessionId}, barCode {barCode}", sessionId, barCode);

            RestResponse response = client.Execute(request);
            System.Net.HttpStatusCode statusCode = response.StatusCode;
            int numericStatusCode = (int)statusCode;
            Log.Debug("<< GK registerLineItem - StatusCode {StatusCode}, numericStatusCode {numericStatusCode}", response.StatusCode, numericStatusCode);
            Log.Verbose("<< GK registerLineItem - Headers {Headers}", response.Headers);
            Log.Verbose("<< GK registerLineItem - Content {Content}", response.Content);

            if (response.IsSuccessful == false)
            {
                if (response.StatusCode == System.Net.HttpStatusCode.InternalServerError)
                {
                    var jsonRespErr = System.Text.Json.JsonSerializer.Deserialize<JsonElement>(response.Content
                        ?? throw new ApplicationException("Null content in response to POST method."));

                    var errorCode = jsonRespErr.GetProperty("errorCode").GetProperty("errorCode").GetString();
                    var message = jsonRespErr.GetProperty("errorCode").GetProperty("message").GetString();
                    var posItemID = jsonRespErr.GetProperty("additionalContextInfoMap").GetProperty("posItemID").GetString();
                    Log.Warning("<< GK registerLineItem - errorCode {errorCode}, message {message}, posItemID {posItemID}",
                            errorCode, message, posItemID);

                    // Item no encontrado.
                    if (errorCode == "GKR-POS-002075")
                    {
                        addItemResponseError = new AddItemResponseError(1,
                            TipoMensaje.Resp, requestId, "Articulo no encontrado", "ITEM_NOT_FOUND");
                        respuesta = new Respuestas { addItemResponseError };
                        return respuesta;
                    }
                }
                // TODO - interpretar la respuesta par amostrar el mensaje de error, ejemplo:
                // {"errorCode":{"errorCode":"GKR-POS-000001","message":"Invalid session","messageKey":"com.gk_software.pos.utils.error.ErrorCodeMessages.MSG_INVALID_SESSION","arguments":[]},"timestamp":"2023-08-04T07:16:57.066","additionalContextInfoMap":{}}
                Log.Error("<< GK registerLineItem failed: StatusCode {StatusCode}, Content {Content}",
                    response.StatusCode, response.Content);
                throw new ApplicationException("Servicio POST 'registerLineItem' en error.");
            }

            var jsonResp = System.Text.Json.JsonSerializer.Deserialize<JsonElement>(response.Content
                        ?? throw new ApplicationException("Null content in response to POST method."));
            var statusOk = jsonResp.GetProperty("statusOk").GetBoolean();

            // La respuesta puede ser IsSuccessful == true pero aún así se debe validar si hay  
            // mas conediciones de falla o alertas asociadas al atrículo.
            if (statusOk == false)
            {
                // var errorCode = jsonResp.GetProperty("failure").GetProperty("errorCode").GetString();
                // var message = jsonResp.GetProperty("failure").GetProperty("errorMessage").GetString();
                // var posItemId = jsonResp.GetProperty("posItemId").GetString();
                // var itemIdx = jsonResp.GetProperty("itemId").GetString();
                // var itemName = jsonResp.GetProperty("itemName").GetString();
                // Log.Warning("<< GK registerLineItem - errorCode {errorCode}, message {message}, posItemID {posItemID}, itemId {itemId}, itemName {itemName}",
                //         errorCode, message, posItemId, itemIdx, itemName);

                Log.Warning("<< GK registerLineItem - statusOk {statusOk}, errorCode {errorCode}, message {message}", statusOk);

                // Position limit exceeded - Price too high!
                // if (errorCode == "GKR-POS-003031")
                // {
                //     addItemResponseError = new AddItemResponseError(1,
                //         TipoMensaje.Resp, requestId, "Precio muy alto, límite excedido", "ITEM_NOT_FOUND");
                //     respuesta = new Respuestas { addItemResponseError };
                //     return respuesta;
                // }

                addItemResponseError = new AddItemResponseError(1,
                        TipoMensaje.Resp, requestId, "Error no reconocido", "ITEM_NOT_FOUND");
                respuesta = new Respuestas { addItemResponseError };
                return respuesta;
            }


            var options2 = new JsonSerializerOptions
            {
                PropertyNameCaseInsensitive = true
            };

            var jObject = JObject.Parse(response.Content);
            var jsonString = jObject["primaryEntry"].ToString();
            var jsonObject = JsonSerializer.Deserialize<primaryEntry>(jsonString, options2);

            var transactionId = jsonObject.transaction.key.transactionID;
            var addedOrModifiedLineItems = jsonObject.addedOrModifiedLineItems;
            var itemId = addedOrModifiedLineItems[0].saleReturnLineItemList[0].itemID;
            var regularUnitPrice = addedOrModifiedLineItems[0].saleReturnLineItemList[0].regularUnitPrice;
            var quantityService = addedOrModifiedLineItems[0].saleReturnLineItemList[0].quantity;
            var units = addedOrModifiedLineItems[0].saleReturnLineItemList[0].units;
            var textName = addedOrModifiedLineItems[0].saleReturnLineItemList[0].receiptText;

            //Pasarlo a string
            var regularUnitPriceTrans = regularUnitPrice.ToString();

            Log.Debug("""
                              << GK registerLineItemTransaction ID: 
                                transactionId {transactionId},
                                addedOrModifiedLineItems {addedOrModifiedLineItems},
                                itemId {itemId},
                                regularUnitPrice {regularUnitPrice},
                                quantityService {quantityService},
                                units {units},
                                textName {textName}
                              """,
                      transactionId,
                      addedOrModifiedLineItems,
                      itemId,
                      regularUnitPrice,
                      quantityService,
                      units,
                      textName
                      );
            Entorno<EntornoGK>.Instancia.get().TransactionID = transactionId;

            string tomarNombreCorto = "";
            //Valores que se mandan en chec
            var date = DateTime.Now.ToString("dd/MM/yyyy");
            CultureInfo culture = new CultureInfo("en-US");
            culture.DateTimeFormat.AMDesignator = "AM";
            culture.DateTimeFormat.PMDesignator = "PM";
            var time = DateTime.Now.ToString("hh:mm tt", culture);

            transactionStatusEvent = new TransactionStatusEvent(1, TipoMensaje.Event, requestId, "TRANSACTION_START", 1, "regularSale", "sales", date, time);
            pOSReceiptEvent = new POSReceiptEvent(1, TipoMensaje.Event, requestId, "Customer", 0, "Body", requestId, 1, "center", "LineItem", "ItemSale", itemId + "   " + textName + "      " + quantityService + "      " + regularUnitPrice, "Add");
            posReceiptEventHeader = new POSReceiptEventHeaderResponse(1, TipoMensaje.Event, requestId);
            totalEvent = new TotalsEventResponse(1, TipoMensaje.Event, requestId, regularUnitPriceTrans, regularUnitPriceTrans, regularUnitPriceTrans, regularUnitPriceTrans, "0.00", "0.00", "0.00", "0.00", "0.00", 1, 0, "0.00", "0.00");
            itemResponse = new AddItemResponse(1, TipoMensaje.Resp, requestId, tomarNombreCorto, "false", "false", "true", "1234", "ScannedItemCode", "3200", 1, "3200", 0, "0.00", 0, 1, 0, "unit", "false", 0, "false", "false", "true", "true");
            respuesta = new Respuestas { transactionStatusEvent, posReceiptEventHeader, pOSReceiptEvent, totalEvent, itemResponse };

            return respuesta;
        }
        public IComando CreaCopia()
        {
            return (AddItemRequestCmdGk)this.MemberwiseClone();
        }

        public void CargaDTO(DTOBase addItemRequestDTO)
        {
            Request = (AddItemRequestDTO)addItemRequestDTO;
        }
    }
}
