﻿using EvaPosSrvDTO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.DTO
{
    ///<summary>
    /// DTO que obtiene los valores del XML "Agregar Cliente"
    /// </summary>
    [XmlRoot(ElementName = "ExpirationDate")]
    public class ExpirationDate
    {

        [XmlElement(ElementName = "Date")]
        public object Date { get; set; }
    }

    [XmlRoot(ElementName = "CustomerIdentifier")]
    public class CustomerIdentifier
    {

        [XmlElement(ElementName = "CustomerID")]
        public string CustomerID { get; set; }

        [XmlElement(ElementName = "Type")]
        public string Type { get; set; }

        [XmlElement(ElementName = "ExpirationDate")]
        public ExpirationDate ExpirationDate { get; set; }
    }

    [XmlRoot(ElementName = "AddCustomerRequest")]
    public class AddCustomerRequest : DTOBase
    {
        public AddCustomerRequest(int idSesion, TipoMensaje tipo) : base(idSesion, tipo)
        {

        }
        public AddCustomerRequest() { }

        [XmlElement(ElementName = "ParameterExtension")]
        public object ParameterExtension { get; set; }

        [XmlElement(ElementName = "RequestID")]
        public int RequestID { get; set; }

        [XmlElement(ElementName = "CustomerIdentifier")]
        public CustomerIdentifier CustomerIdentifier { get; set; }
    }
}
