﻿using EvaPosSrvDTO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.DTO
{
    ///<summary>
    /// DTO que obtiene los valores del XML "Agregar a la bolsa"
    /// </summary>

    [XmlRoot(ElementName = "OriginalRequest")]
    public class OriginalRequest
    {

        [XmlElement(ElementName = "Group")]
        public int Group { get; set; }

        [XmlElement(ElementName = "Location")]
        public string Location { get; set; }
    }

    [XmlRoot(ElementName = "TextReceiptLine")]
    public class TextReceiptLine
    {

        [XmlElement(ElementName = "Bold")]
        public int Bold { get; set; }

        [XmlElement(ElementName = "Text")]
        public string Text { get; set; }
    }

    [XmlRoot(ElementName = "FormattedReceiptLine")]
    public class FormattedReceiptLine
    {

        [XmlElement(ElementName = "Feeds")]
        public int Feeds { get; set; }

        [XmlElement(ElementName = "Align")]
        public string Align { get; set; }

        [XmlElement(ElementName = "LineCategory")]
        public string LineCategory { get; set; }

        [XmlElement(ElementName = "LineType")]
        public string LineType { get; set; }

        [XmlElement(ElementName = "TextReceiptLine")]
        public TextReceiptLine TextReceiptLine { get; set; }
    }

    [XmlRoot(ElementName = "AddReceiptLinesRequest")]
    public class AddReceiptLinesRequest : DTOBase
    {
        public AddReceiptLinesRequest(int idSesion, TipoMensaje tipo) : base(idSesion, tipo)
        {
        }
        public AddReceiptLinesRequest()
        {
        }

        [XmlElement(ElementName = "ParameterExtension")]
        public object ParameterExtension { get; set; }

        [XmlElement(ElementName = "RequestID")]
        public int RequestID { get; set; }

        [XmlElement(ElementName = "Type")]
        public string Type { get; set; }

        [XmlElement(ElementName = "Index")]
        public int Index { get; set; }

        [XmlElement(ElementName = "Section")]
        public string Section { get; set; }

        [XmlElement(ElementName = "OriginalRequest")]
        public OriginalRequest OriginalRequest { get; set; }

        [XmlElement(ElementName = "FormattedReceiptLine")]
        public FormattedReceiptLine FormattedReceiptLine { get; set; }
    }

}
