﻿using EvaPosSrvDTO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace EvaPOS_API_FRAME.DTO
{
    ///<summary>
    /// DTO que obtiene los valores del XML "Saltar Empaque"
    /// </summary>
    public class RemoveReceiptLinesDTO
    {
        [XmlRoot(ElementName = "OriginalRequest")] 
        public class OriginalRequest
        {

            [XmlElement(ElementName = "Group")]
            public int Group { get; set; }

            [XmlElement(ElementName = "Location")]
            public string Location { get; set; }
        }

        [XmlRoot(ElementName = "RemoveReceiptLinesRequest")]
        public class RemoveReceiptLinesRequest : DTOBase
        {
            public RemoveReceiptLinesRequest(int idSesion, TipoMensaje tipo) : base(idSesion, tipo)
            {
            }
            public RemoveReceiptLinesRequest()
            {
            }

            [XmlElement(ElementName = "ParameterExtension")]
            public object ParameterExtension { get; set; }

            [XmlElement(ElementName = "RequestID")]
            public int RequestID { get; set; }

            [XmlElement(ElementName = "Type")]
            public string Type { get; set; }

            [XmlElement(ElementName = "Index")]
            public int Index { get; set; }

            [XmlElement(ElementName = "Section")]
            public string Section { get; set; }

            [XmlElement(ElementName = "OriginalRequest")]
            public OriginalRequest OriginalRequest { get; set; }
        }
    }
}
