/// <summary>
///  Clase que representa los parámetros de configuración de la aplicación
///  registrados en el archivo appsettings.json (o equivalente definido).
/// </summary>
public sealed class Config
{
    public required string POS { get; set; } = "ECO";
    public required string IpGateway { get; set; } = "127.0.0.1";
    public required int PortGateway { get; set; } = 6697;
    public required string Language { get; set; } = "en";

    public override string ToString()
   {
      return base.ToString() + " - " + $"POS: '{POS}', IpGateway: '{IpGateway}', PortGateway: '{PortGateway}', Language: '{Language}'";
   }
}