/// <summary>
///  Clase que representa los parámetros de configuración de la aplicación
///  registrados en el archivo appsettings.json asociados a POSBC.
/// </summary>
public sealed class ConfigPOSBC
{
    public required string IpPOSBC { get; set; } = "127.0.0.1";
    public required int PortPOSBC { get; set; } = 6698;

    public override string ToString()
    {
        return base.ToString() + $" - IpPOSBC: '{IpPOSBC}', PortPOSBC: '{PortPOSBC}' ";
    }
}