/// <summary>
/// Directorio de comandos.
/// Almacena instancia de comandos indexadas por su Referencia.
/// Usado para identificar el comando que procesa un mensaje particular
/// asociado por la propiedad Referencia del comando.
/// </summary>
public class CreaDirectorioCmds
    {
        private Dictionary<string, IComando> dir = new Dictionary<string, IComando>();

        /// <summary>
        /// Agrega un comando al directorio.
        /// </summary>
        public void AgregaComando(IComando cmd)
        {
            dir.Add(cmd.Referencia, cmd);
        }

        /// <summary>
        /// Recupera una "shallow copy" del comando asociado al parámmetro.
        /// </summary>
        public IComando ObtieneComando(string referencia)
        {
            IComando cmd;
            try
            {
                cmd = dir[referencia];
            }
            catch (KeyNotFoundException)
            {
                throw new Exception($"No se encuentra comando con referencia '{referencia}'.");
            }
            return cmd.CreaCopia();
        }
    }