using EvaPOS_API_FRAME.Comandos;
using Serilog;

/// <summary>
/// Instancia directorio de comandos de prueba con cada
/// uno de los comandos.
/// </summary>
public class DispensaDirectorioCmdsPruebas : IDispensaDirectorioCmds
{
    /// <summary>
    /// Retorna directorio de comandos instanciado y poblado de
    /// comandos. 
    /// </summary>
    public static CreaDirectorioCmds Dispensa()
    {
        Log.Information("Instancia comandos de prueba.");
        return new IniciaDirectorioCmds()
        .AgregaCmd(new ErrorCmd())
        .AgregaCmd(new AddItemRequestCmd())
        .AgregaCmd(new InitializeRequestCmd())
        .AgregaCmd(new QueryStatusRequestCmd())
        .AgregaCmd(new ReportStatusEventsRequestCmd())
        .AgregaCmd(new SignOffResponseCmd())
        .AgregaCmd(new AddReceiptLinesRequestCmd())
        .AgregaCmd(new GetTotalsRequestCmd())
        .AgregaCmd(new AddTenderDebitCmd())
        .AgregaCmd(new PrintCurrentReceiptsRequestCmd())
        .AgregaCmd(new ReprintReceiptsCmd())
        .AgregaCmd(new TerminateRequestCmd())
        .AgregaCmd(new VoidTransactionCmd())
        .AgregaCmd(new RemoveReceiptLinesCmd())
        .AgregaCmd(new CancelActionCmd())
        .AgregaCmd(new AddCustomerBirthdateCmd())
        .AgregaCmd(new AddCustomerCmd())
        .AgregaCmd(new SuspendTransactionRequestCmd())
        .DirectorioCmds;
    }
}