using Serilog;
namespace GatewaySCO
{
    /// <summary>
    /// Clase singleton que mantiene valores y objetos de interes global.
    /// </summary>
    public sealed class Entorno<T>
    {
        /// <summary>
        /// Instanciador singleton.
        /// </summary>
        private static readonly Lazy<Entorno<T>> lazy = new Lazy<Entorno<T>>(() => new Entorno<T>());

        /// <summary>
        /// Acceso a instancia del singleton.
        /// </summary>
        public static Entorno<T> Instancia { get { return lazy.Value; } }

        /// <summary>
        /// Datos particulares de cada implementación de POS.
        /// </summary>
        private static T? _datos;

        /// <summary>
        /// Constructor privado.
        /// </summary>
        private Entorno()
        {
            Log.Debug("Entorno inicializado.");
        }

        /// <summary>
        /// Obtener datos de entorno.
        /// </summary>
        public T get()
        {
            if (_datos == null)
            {
                throw new ApplicationException("Datos de entorno no inicializados.");
            }
            return _datos;
        }

        /// <summary>
        /// Fijar datos de entorno.
        /// </summary>
        public void set(T datos)
        {
            _datos = datos;
        }
    }
}
