/* 
 * GK application - OmniPOS Service API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 5.21.1-b03
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;

namespace IO.Swagger.Model
{
    /// <summary>
    /// RetailTransactionPriceDerivationRule &lt;p&gt;Retail transaction price derivation rule describes a promotion rule.&lt;/p&gt;
    /// </summary>
    [DataContract]
    public partial class ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule :  IEquatable<ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule" /> class.
        /// </summary>
        /// <param name="promotionID">&lt;p&gt;The unique identifier of the promotion.&lt;/p&gt; (required).</param>
        /// <param name="priceDerivationRuleID">&lt;p&gt;The unique identifier of the price derivation rule.&lt;/p&gt;.</param>
        /// <param name="priceDerivationRuleEligibilityID">&lt;p&gt;The unique identifier of the root eligibility.&lt;/p&gt;.</param>
        /// <param name="promotionDescription">&lt;p&gt;Short description of the promotion.&lt;/p&gt;.</param>
        /// <param name="receiptPrinterName">&lt;p&gt;Text to be printed on the receipt.&lt;/p&gt;.</param>
        /// <param name="promotionPriceDerivationRuleSequence">&lt;p&gt;Promotion price derivation rule Sequence used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleResolution.&lt;/p&gt;.</param>
        /// <param name="promotionPriceDerivationRuleResolution">&lt;p&gt;Promotion price derivation resolution used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleSequence.&lt;/p&gt;.</param>
        /// <param name="promotionPriceDerivationRuleTypeCode">&lt;p&gt;The type code of the promotion price derivation rule.&lt;/p&gt;.</param>
        /// <param name="priceModificationMethodCode">&lt;p&gt;A code denoting the method of modifying the price that is being applied to the transaction line item.&lt;/p&gt;.</param>
        /// <param name="priceDerivationRuleDescription">&lt;p&gt;Business description for this price derivation rule.&lt;/p&gt;.</param>
        /// <param name="promotionOriginatorTypeCode">&lt;p&gt;The type code of the originator of the promotion.&lt;/p&gt;.</param>
        /// <param name="externalPromotionID">&lt;p&gt;The external identifier of the promotion.&lt;/p&gt;.</param>
        /// <param name="externalPriceDerivationRuleID">&lt;p&gt;The external identifier of the price derivation rule.&lt;/p&gt;.</param>
        /// <param name="triggerQuantity">&lt;p&gt;The quantity of items fulfilling the eligibility which is required in order to trigger the price derivation rule.&lt;/p&gt;.</param>
        /// <param name="giftCertificateExpirationDate">&lt;p&gt;End of the date range in which the gift certificate is valid.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone).</param>
        /// <param name="discountMethodCode">&lt;p&gt;Determines how the discount influences the transaction.&lt;/p&gt;.</param>
        /// <param name="prohibitPrintFlag">&lt;p&gt;Determines whether the result of the applied price derivation rule is to be suppressed on displays / not printed on the receipt; e.g. line item-related default points are not printed after each position, but only summarized at the end of the receipt.&lt;/p&gt; (required).</param>
        /// <param name="tenderTypeCode">&lt;p&gt;A code which uniquely identifies the tender in case of rebate as tender.&lt;/p&gt;.</param>
        /// <param name="promotionTypeName">&lt;p&gt;Promotion type name&lt;/p&gt;.</param>
        /// <param name="calculationBase">calculationBase.</param>
        /// <param name="noEffectOnSubsequentPriceDerivationRulesFlag">&lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent price derivation rules (false) or not (true).&lt;/p&gt; (required).</param>
        /// <param name="prohibitTransactionRelatedPriceDerivationRulesFlag">&lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent transaction-related price derivation rules (false) or not (true); is relevant for line item-related &#39;money&#39; price derivation rules only.&lt;/p&gt; (required).</param>
        /// <param name="couponPrintoutID">&lt;p&gt;The number of the printout coupon.&lt;/p&gt;.</param>
        /// <param name="couponPrintoutRule">&lt;p&gt;The type code of the printout rule.&lt;/p&gt;.</param>
        /// <param name="couponPrintoutText">&lt;p&gt;The formatted text of the printout coupon.&lt;/p&gt;.</param>
        /// <param name="exclusiveFlag">&lt;p&gt;Determines whether this price derivation rule is an exclusive one.&lt;/p&gt; (required).</param>
        /// <param name="concurrenceControlVector">&lt;p&gt;Determines how this price derivation rule works in relation to other applicable price derivation rules.&lt;/p&gt;.</param>
        /// <param name="appliedCount">&lt;p&gt;Describes how often the current price derivation rule was applied.&lt;/p&gt;.</param>
        /// <param name="printoutValidityPeriod">&lt;p&gt;Describes how long (how many days) the printed coupon/gift certificate is valid.&lt;/p&gt; (required).</param>
        /// <param name="xXCustom08">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom10">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom09">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom07">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom05">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom06">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom11">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom12">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom13">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom14">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom15">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom03">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom02">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom04">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        /// <param name="xXCustom01">&lt;p&gt;Customizable information&lt;/p&gt;.</param>
        public ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule(string promotionID = default(string), string priceDerivationRuleID = default(string), string priceDerivationRuleEligibilityID = default(string), string promotionDescription = default(string), string receiptPrinterName = default(string), string promotionPriceDerivationRuleSequence = default(string), string promotionPriceDerivationRuleResolution = default(string), string promotionPriceDerivationRuleTypeCode = default(string), string priceModificationMethodCode = default(string), string priceDerivationRuleDescription = default(string), string promotionOriginatorTypeCode = default(string), string externalPromotionID = default(string), string externalPriceDerivationRuleID = default(string), double? triggerQuantity = default(double?), string giftCertificateExpirationDate = default(string), string discountMethodCode = default(string), bool? prohibitPrintFlag = default(bool?), string tenderTypeCode = default(string), string promotionTypeName = default(string), string calculationBase = default(string), bool? noEffectOnSubsequentPriceDerivationRulesFlag = default(bool?), bool? prohibitTransactionRelatedPriceDerivationRulesFlag = default(bool?), string couponPrintoutID = default(string), string couponPrintoutRule = default(string), string couponPrintoutText = default(string), bool? exclusiveFlag = default(bool?), string concurrenceControlVector = default(string), double? appliedCount = default(double?), double? printoutValidityPeriod = default(double?), string xXCustom08 = default(string), string xXCustom10 = default(string), string xXCustom09 = default(string), string xXCustom07 = default(string), string xXCustom05 = default(string), string xXCustom06 = default(string), string xXCustom11 = default(string), string xXCustom12 = default(string), string xXCustom13 = default(string), string xXCustom14 = default(string), string xXCustom15 = default(string), string xXCustom03 = default(string), string xXCustom02 = default(string), string xXCustom04 = default(string), string xXCustom01 = default(string))
        {
            // to ensure "promotionID" is required (not null)
            if (promotionID == null)
            {
                throw new InvalidDataException("promotionID is a required property for ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule and cannot be null");
            }
            else
            {
                this.PromotionID = promotionID;
            }
            // to ensure "prohibitPrintFlag" is required (not null)
            if (prohibitPrintFlag == null)
            {
                throw new InvalidDataException("prohibitPrintFlag is a required property for ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule and cannot be null");
            }
            else
            {
                this.ProhibitPrintFlag = prohibitPrintFlag;
            }
            // to ensure "noEffectOnSubsequentPriceDerivationRulesFlag" is required (not null)
            if (noEffectOnSubsequentPriceDerivationRulesFlag == null)
            {
                throw new InvalidDataException("noEffectOnSubsequentPriceDerivationRulesFlag is a required property for ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule and cannot be null");
            }
            else
            {
                this.NoEffectOnSubsequentPriceDerivationRulesFlag = noEffectOnSubsequentPriceDerivationRulesFlag;
            }
            // to ensure "prohibitTransactionRelatedPriceDerivationRulesFlag" is required (not null)
            if (prohibitTransactionRelatedPriceDerivationRulesFlag == null)
            {
                throw new InvalidDataException("prohibitTransactionRelatedPriceDerivationRulesFlag is a required property for ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule and cannot be null");
            }
            else
            {
                this.ProhibitTransactionRelatedPriceDerivationRulesFlag = prohibitTransactionRelatedPriceDerivationRulesFlag;
            }
            // to ensure "exclusiveFlag" is required (not null)
            if (exclusiveFlag == null)
            {
                throw new InvalidDataException("exclusiveFlag is a required property for ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule and cannot be null");
            }
            else
            {
                this.ExclusiveFlag = exclusiveFlag;
            }
            // to ensure "printoutValidityPeriod" is required (not null)
            if (printoutValidityPeriod == null)
            {
                throw new InvalidDataException("printoutValidityPeriod is a required property for ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule and cannot be null");
            }
            else
            {
                this.PrintoutValidityPeriod = printoutValidityPeriod;
            }
            this.PriceDerivationRuleID = priceDerivationRuleID;
            this.PriceDerivationRuleEligibilityID = priceDerivationRuleEligibilityID;
            this.PromotionDescription = promotionDescription;
            this.ReceiptPrinterName = receiptPrinterName;
            this.PromotionPriceDerivationRuleSequence = promotionPriceDerivationRuleSequence;
            this.PromotionPriceDerivationRuleResolution = promotionPriceDerivationRuleResolution;
            this.PromotionPriceDerivationRuleTypeCode = promotionPriceDerivationRuleTypeCode;
            this.PriceModificationMethodCode = priceModificationMethodCode;
            this.PriceDerivationRuleDescription = priceDerivationRuleDescription;
            this.PromotionOriginatorTypeCode = promotionOriginatorTypeCode;
            this.ExternalPromotionID = externalPromotionID;
            this.ExternalPriceDerivationRuleID = externalPriceDerivationRuleID;
            this.TriggerQuantity = triggerQuantity;
            this.GiftCertificateExpirationDate = giftCertificateExpirationDate;
            this.DiscountMethodCode = discountMethodCode;
            this.TenderTypeCode = tenderTypeCode;
            this.PromotionTypeName = promotionTypeName;
            this.CalculationBase = calculationBase;
            this.CouponPrintoutID = couponPrintoutID;
            this.CouponPrintoutRule = couponPrintoutRule;
            this.CouponPrintoutText = couponPrintoutText;
            this.ConcurrenceControlVector = concurrenceControlVector;
            this.AppliedCount = appliedCount;
            this.XXCustom08 = xXCustom08;
            this.XXCustom10 = xXCustom10;
            this.XXCustom09 = xXCustom09;
            this.XXCustom07 = xXCustom07;
            this.XXCustom05 = xXCustom05;
            this.XXCustom06 = xXCustom06;
            this.XXCustom11 = xXCustom11;
            this.XXCustom12 = xXCustom12;
            this.XXCustom13 = xXCustom13;
            this.XXCustom14 = xXCustom14;
            this.XXCustom15 = xXCustom15;
            this.XXCustom03 = xXCustom03;
            this.XXCustom02 = xXCustom02;
            this.XXCustom04 = xXCustom04;
            this.XXCustom01 = xXCustom01;
        }
        
        /// <summary>
        /// &lt;p&gt;The unique identifier of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier of the promotion.&lt;/p&gt;</value>
        [DataMember(Name="promotionID", EmitDefaultValue=false)]
        public string PromotionID { get; set; }

        /// <summary>
        /// &lt;p&gt;The unique identifier of the price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier of the price derivation rule.&lt;/p&gt;</value>
        [DataMember(Name="priceDerivationRuleID", EmitDefaultValue=false)]
        public string PriceDerivationRuleID { get; set; }

        /// <summary>
        /// &lt;p&gt;The unique identifier of the root eligibility.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier of the root eligibility.&lt;/p&gt;</value>
        [DataMember(Name="priceDerivationRuleEligibilityID", EmitDefaultValue=false)]
        public string PriceDerivationRuleEligibilityID { get; set; }

        /// <summary>
        /// &lt;p&gt;Short description of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Short description of the promotion.&lt;/p&gt;</value>
        [DataMember(Name="promotionDescription", EmitDefaultValue=false)]
        public string PromotionDescription { get; set; }

        /// <summary>
        /// &lt;p&gt;Text to be printed on the receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Text to be printed on the receipt.&lt;/p&gt;</value>
        [DataMember(Name="receiptPrinterName", EmitDefaultValue=false)]
        public string ReceiptPrinterName { get; set; }

        /// <summary>
        /// &lt;p&gt;Promotion price derivation rule Sequence used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleResolution.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Promotion price derivation rule Sequence used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleResolution.&lt;/p&gt;</value>
        [DataMember(Name="promotionPriceDerivationRuleSequence", EmitDefaultValue=false)]
        public string PromotionPriceDerivationRuleSequence { get; set; }

        /// <summary>
        /// &lt;p&gt;Promotion price derivation resolution used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleSequence.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Promotion price derivation resolution used for collision handling (multiple possible promotions applied to same transaction/line item).&lt;br /&gt; Used in combination with promotionPriceDerivationRuleSequence.&lt;/p&gt;</value>
        [DataMember(Name="promotionPriceDerivationRuleResolution", EmitDefaultValue=false)]
        public string PromotionPriceDerivationRuleResolution { get; set; }

        /// <summary>
        /// &lt;p&gt;The type code of the promotion price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The type code of the promotion price derivation rule.&lt;/p&gt;</value>
        [DataMember(Name="promotionPriceDerivationRuleTypeCode", EmitDefaultValue=false)]
        public string PromotionPriceDerivationRuleTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;A code denoting the method of modifying the price that is being applied to the transaction line item.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code denoting the method of modifying the price that is being applied to the transaction line item.&lt;/p&gt;</value>
        [DataMember(Name="priceModificationMethodCode", EmitDefaultValue=false)]
        public string PriceModificationMethodCode { get; set; }

        /// <summary>
        /// &lt;p&gt;Business description for this price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Business description for this price derivation rule.&lt;/p&gt;</value>
        [DataMember(Name="priceDerivationRuleDescription", EmitDefaultValue=false)]
        public string PriceDerivationRuleDescription { get; set; }

        /// <summary>
        /// &lt;p&gt;The type code of the originator of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The type code of the originator of the promotion.&lt;/p&gt;</value>
        [DataMember(Name="promotionOriginatorTypeCode", EmitDefaultValue=false)]
        public string PromotionOriginatorTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;The external identifier of the promotion.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The external identifier of the promotion.&lt;/p&gt;</value>
        [DataMember(Name="externalPromotionID", EmitDefaultValue=false)]
        public string ExternalPromotionID { get; set; }

        /// <summary>
        /// &lt;p&gt;The external identifier of the price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The external identifier of the price derivation rule.&lt;/p&gt;</value>
        [DataMember(Name="externalPriceDerivationRuleID", EmitDefaultValue=false)]
        public string ExternalPriceDerivationRuleID { get; set; }

        /// <summary>
        /// &lt;p&gt;The quantity of items fulfilling the eligibility which is required in order to trigger the price derivation rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The quantity of items fulfilling the eligibility which is required in order to trigger the price derivation rule.&lt;/p&gt;</value>
        [DataMember(Name="triggerQuantity", EmitDefaultValue=false)]
        public double? TriggerQuantity { get; set; }

        /// <summary>
        /// &lt;p&gt;End of the date range in which the gift certificate is valid.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;End of the date range in which the gift certificate is valid.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        [DataMember(Name="giftCertificateExpirationDate", EmitDefaultValue=false)]
        public string GiftCertificateExpirationDate { get; set; }

        /// <summary>
        /// &lt;p&gt;Determines how the discount influences the transaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how the discount influences the transaction.&lt;/p&gt;</value>
        [DataMember(Name="discountMethodCode", EmitDefaultValue=false)]
        public string DiscountMethodCode { get; set; }

        /// <summary>
        /// &lt;p&gt;Determines whether the result of the applied price derivation rule is to be suppressed on displays / not printed on the receipt; e.g. line item-related default points are not printed after each position, but only summarized at the end of the receipt.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the result of the applied price derivation rule is to be suppressed on displays / not printed on the receipt; e.g. line item-related default points are not printed after each position, but only summarized at the end of the receipt.&lt;/p&gt;</value>
        [DataMember(Name="prohibitPrintFlag", EmitDefaultValue=false)]
        public bool? ProhibitPrintFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;A code which uniquely identifies the tender in case of rebate as tender.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code which uniquely identifies the tender in case of rebate as tender.&lt;/p&gt;</value>
        [DataMember(Name="tenderTypeCode", EmitDefaultValue=false)]
        public string TenderTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;Promotion type name&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Promotion type name&lt;/p&gt;</value>
        [DataMember(Name="promotionTypeName", EmitDefaultValue=false)]
        public string PromotionTypeName { get; set; }

        /// <summary>
        /// Gets or Sets CalculationBase
        /// </summary>
        [DataMember(Name="calculationBase", EmitDefaultValue=false)]
        public string CalculationBase { get; set; }

        /// <summary>
        /// &lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent price derivation rules (false) or not (true).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent price derivation rules (false) or not (true).&lt;/p&gt;</value>
        [DataMember(Name="noEffectOnSubsequentPriceDerivationRulesFlag", EmitDefaultValue=false)]
        public bool? NoEffectOnSubsequentPriceDerivationRulesFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent transaction-related price derivation rules (false) or not (true); is relevant for line item-related &#39;money&#39; price derivation rules only.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether applying this price derivation rule influences the calculation base of subsequent transaction-related price derivation rules (false) or not (true); is relevant for line item-related &#39;money&#39; price derivation rules only.&lt;/p&gt;</value>
        [DataMember(Name="prohibitTransactionRelatedPriceDerivationRulesFlag", EmitDefaultValue=false)]
        public bool? ProhibitTransactionRelatedPriceDerivationRulesFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;The number of the printout coupon.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The number of the printout coupon.&lt;/p&gt;</value>
        [DataMember(Name="couponPrintoutID", EmitDefaultValue=false)]
        public string CouponPrintoutID { get; set; }

        /// <summary>
        /// &lt;p&gt;The type code of the printout rule.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The type code of the printout rule.&lt;/p&gt;</value>
        [DataMember(Name="couponPrintoutRule", EmitDefaultValue=false)]
        public string CouponPrintoutRule { get; set; }

        /// <summary>
        /// &lt;p&gt;The formatted text of the printout coupon.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The formatted text of the printout coupon.&lt;/p&gt;</value>
        [DataMember(Name="couponPrintoutText", EmitDefaultValue=false)]
        public string CouponPrintoutText { get; set; }

        /// <summary>
        /// &lt;p&gt;Determines whether this price derivation rule is an exclusive one.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this price derivation rule is an exclusive one.&lt;/p&gt;</value>
        [DataMember(Name="exclusiveFlag", EmitDefaultValue=false)]
        public bool? ExclusiveFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;Determines how this price derivation rule works in relation to other applicable price derivation rules.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how this price derivation rule works in relation to other applicable price derivation rules.&lt;/p&gt;</value>
        [DataMember(Name="concurrenceControlVector", EmitDefaultValue=false)]
        public string ConcurrenceControlVector { get; set; }

        /// <summary>
        /// &lt;p&gt;Describes how often the current price derivation rule was applied.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Describes how often the current price derivation rule was applied.&lt;/p&gt;</value>
        [DataMember(Name="appliedCount", EmitDefaultValue=false)]
        public double? AppliedCount { get; set; }

        /// <summary>
        /// &lt;p&gt;Describes how long (how many days) the printed coupon/gift certificate is valid.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Describes how long (how many days) the printed coupon/gift certificate is valid.&lt;/p&gt;</value>
        [DataMember(Name="printoutValidityPeriod", EmitDefaultValue=false)]
        public double? PrintoutValidityPeriod { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom08", EmitDefaultValue=false)]
        public string XXCustom08 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom10", EmitDefaultValue=false)]
        public string XXCustom10 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom09", EmitDefaultValue=false)]
        public string XXCustom09 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom07", EmitDefaultValue=false)]
        public string XXCustom07 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom05", EmitDefaultValue=false)]
        public string XXCustom05 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom06", EmitDefaultValue=false)]
        public string XXCustom06 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom11", EmitDefaultValue=false)]
        public string XXCustom11 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom12", EmitDefaultValue=false)]
        public string XXCustom12 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom13", EmitDefaultValue=false)]
        public string XXCustom13 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom14", EmitDefaultValue=false)]
        public string XXCustom14 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom15", EmitDefaultValue=false)]
        public string XXCustom15 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom03", EmitDefaultValue=false)]
        public string XXCustom03 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom02", EmitDefaultValue=false)]
        public string XXCustom02 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom04", EmitDefaultValue=false)]
        public string XXCustom04 { get; set; }

        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        [DataMember(Name="xXCustom01", EmitDefaultValue=false)]
        public string XXCustom01 { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule {\n");
            sb.Append("  PromotionID: ").Append(PromotionID).Append("\n");
            sb.Append("  PriceDerivationRuleID: ").Append(PriceDerivationRuleID).Append("\n");
            sb.Append("  PriceDerivationRuleEligibilityID: ").Append(PriceDerivationRuleEligibilityID).Append("\n");
            sb.Append("  PromotionDescription: ").Append(PromotionDescription).Append("\n");
            sb.Append("  ReceiptPrinterName: ").Append(ReceiptPrinterName).Append("\n");
            sb.Append("  PromotionPriceDerivationRuleSequence: ").Append(PromotionPriceDerivationRuleSequence).Append("\n");
            sb.Append("  PromotionPriceDerivationRuleResolution: ").Append(PromotionPriceDerivationRuleResolution).Append("\n");
            sb.Append("  PromotionPriceDerivationRuleTypeCode: ").Append(PromotionPriceDerivationRuleTypeCode).Append("\n");
            sb.Append("  PriceModificationMethodCode: ").Append(PriceModificationMethodCode).Append("\n");
            sb.Append("  PriceDerivationRuleDescription: ").Append(PriceDerivationRuleDescription).Append("\n");
            sb.Append("  PromotionOriginatorTypeCode: ").Append(PromotionOriginatorTypeCode).Append("\n");
            sb.Append("  ExternalPromotionID: ").Append(ExternalPromotionID).Append("\n");
            sb.Append("  ExternalPriceDerivationRuleID: ").Append(ExternalPriceDerivationRuleID).Append("\n");
            sb.Append("  TriggerQuantity: ").Append(TriggerQuantity).Append("\n");
            sb.Append("  GiftCertificateExpirationDate: ").Append(GiftCertificateExpirationDate).Append("\n");
            sb.Append("  DiscountMethodCode: ").Append(DiscountMethodCode).Append("\n");
            sb.Append("  ProhibitPrintFlag: ").Append(ProhibitPrintFlag).Append("\n");
            sb.Append("  TenderTypeCode: ").Append(TenderTypeCode).Append("\n");
            sb.Append("  PromotionTypeName: ").Append(PromotionTypeName).Append("\n");
            sb.Append("  CalculationBase: ").Append(CalculationBase).Append("\n");
            sb.Append("  NoEffectOnSubsequentPriceDerivationRulesFlag: ").Append(NoEffectOnSubsequentPriceDerivationRulesFlag).Append("\n");
            sb.Append("  ProhibitTransactionRelatedPriceDerivationRulesFlag: ").Append(ProhibitTransactionRelatedPriceDerivationRulesFlag).Append("\n");
            sb.Append("  CouponPrintoutID: ").Append(CouponPrintoutID).Append("\n");
            sb.Append("  CouponPrintoutRule: ").Append(CouponPrintoutRule).Append("\n");
            sb.Append("  CouponPrintoutText: ").Append(CouponPrintoutText).Append("\n");
            sb.Append("  ExclusiveFlag: ").Append(ExclusiveFlag).Append("\n");
            sb.Append("  ConcurrenceControlVector: ").Append(ConcurrenceControlVector).Append("\n");
            sb.Append("  AppliedCount: ").Append(AppliedCount).Append("\n");
            sb.Append("  PrintoutValidityPeriod: ").Append(PrintoutValidityPeriod).Append("\n");
            sb.Append("  XXCustom08: ").Append(XXCustom08).Append("\n");
            sb.Append("  XXCustom10: ").Append(XXCustom10).Append("\n");
            sb.Append("  XXCustom09: ").Append(XXCustom09).Append("\n");
            sb.Append("  XXCustom07: ").Append(XXCustom07).Append("\n");
            sb.Append("  XXCustom05: ").Append(XXCustom05).Append("\n");
            sb.Append("  XXCustom06: ").Append(XXCustom06).Append("\n");
            sb.Append("  XXCustom11: ").Append(XXCustom11).Append("\n");
            sb.Append("  XXCustom12: ").Append(XXCustom12).Append("\n");
            sb.Append("  XXCustom13: ").Append(XXCustom13).Append("\n");
            sb.Append("  XXCustom14: ").Append(XXCustom14).Append("\n");
            sb.Append("  XXCustom15: ").Append(XXCustom15).Append("\n");
            sb.Append("  XXCustom03: ").Append(XXCustom03).Append("\n");
            sb.Append("  XXCustom02: ").Append(XXCustom02).Append("\n");
            sb.Append("  XXCustom04: ").Append(XXCustom04).Append("\n");
            sb.Append("  XXCustom01: ").Append(XXCustom01).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule);
        }

        /// <summary>
        /// Returns true if ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule instances are equal
        /// </summary>
        /// <param name="input">Instance of ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ComGkSoftwarePosApiModelDomAppServicesTransactionRetailTransactionPriceDerivationRule input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.PromotionID == input.PromotionID ||
                    (this.PromotionID != null &&
                    this.PromotionID.Equals(input.PromotionID))
                ) && 
                (
                    this.PriceDerivationRuleID == input.PriceDerivationRuleID ||
                    (this.PriceDerivationRuleID != null &&
                    this.PriceDerivationRuleID.Equals(input.PriceDerivationRuleID))
                ) && 
                (
                    this.PriceDerivationRuleEligibilityID == input.PriceDerivationRuleEligibilityID ||
                    (this.PriceDerivationRuleEligibilityID != null &&
                    this.PriceDerivationRuleEligibilityID.Equals(input.PriceDerivationRuleEligibilityID))
                ) && 
                (
                    this.PromotionDescription == input.PromotionDescription ||
                    (this.PromotionDescription != null &&
                    this.PromotionDescription.Equals(input.PromotionDescription))
                ) && 
                (
                    this.ReceiptPrinterName == input.ReceiptPrinterName ||
                    (this.ReceiptPrinterName != null &&
                    this.ReceiptPrinterName.Equals(input.ReceiptPrinterName))
                ) && 
                (
                    this.PromotionPriceDerivationRuleSequence == input.PromotionPriceDerivationRuleSequence ||
                    (this.PromotionPriceDerivationRuleSequence != null &&
                    this.PromotionPriceDerivationRuleSequence.Equals(input.PromotionPriceDerivationRuleSequence))
                ) && 
                (
                    this.PromotionPriceDerivationRuleResolution == input.PromotionPriceDerivationRuleResolution ||
                    (this.PromotionPriceDerivationRuleResolution != null &&
                    this.PromotionPriceDerivationRuleResolution.Equals(input.PromotionPriceDerivationRuleResolution))
                ) && 
                (
                    this.PromotionPriceDerivationRuleTypeCode == input.PromotionPriceDerivationRuleTypeCode ||
                    (this.PromotionPriceDerivationRuleTypeCode != null &&
                    this.PromotionPriceDerivationRuleTypeCode.Equals(input.PromotionPriceDerivationRuleTypeCode))
                ) && 
                (
                    this.PriceModificationMethodCode == input.PriceModificationMethodCode ||
                    (this.PriceModificationMethodCode != null &&
                    this.PriceModificationMethodCode.Equals(input.PriceModificationMethodCode))
                ) && 
                (
                    this.PriceDerivationRuleDescription == input.PriceDerivationRuleDescription ||
                    (this.PriceDerivationRuleDescription != null &&
                    this.PriceDerivationRuleDescription.Equals(input.PriceDerivationRuleDescription))
                ) && 
                (
                    this.PromotionOriginatorTypeCode == input.PromotionOriginatorTypeCode ||
                    (this.PromotionOriginatorTypeCode != null &&
                    this.PromotionOriginatorTypeCode.Equals(input.PromotionOriginatorTypeCode))
                ) && 
                (
                    this.ExternalPromotionID == input.ExternalPromotionID ||
                    (this.ExternalPromotionID != null &&
                    this.ExternalPromotionID.Equals(input.ExternalPromotionID))
                ) && 
                (
                    this.ExternalPriceDerivationRuleID == input.ExternalPriceDerivationRuleID ||
                    (this.ExternalPriceDerivationRuleID != null &&
                    this.ExternalPriceDerivationRuleID.Equals(input.ExternalPriceDerivationRuleID))
                ) && 
                (
                    this.TriggerQuantity == input.TriggerQuantity ||
                    (this.TriggerQuantity != null &&
                    this.TriggerQuantity.Equals(input.TriggerQuantity))
                ) && 
                (
                    this.GiftCertificateExpirationDate == input.GiftCertificateExpirationDate ||
                    (this.GiftCertificateExpirationDate != null &&
                    this.GiftCertificateExpirationDate.Equals(input.GiftCertificateExpirationDate))
                ) && 
                (
                    this.DiscountMethodCode == input.DiscountMethodCode ||
                    (this.DiscountMethodCode != null &&
                    this.DiscountMethodCode.Equals(input.DiscountMethodCode))
                ) && 
                (
                    this.ProhibitPrintFlag == input.ProhibitPrintFlag ||
                    (this.ProhibitPrintFlag != null &&
                    this.ProhibitPrintFlag.Equals(input.ProhibitPrintFlag))
                ) && 
                (
                    this.TenderTypeCode == input.TenderTypeCode ||
                    (this.TenderTypeCode != null &&
                    this.TenderTypeCode.Equals(input.TenderTypeCode))
                ) && 
                (
                    this.PromotionTypeName == input.PromotionTypeName ||
                    (this.PromotionTypeName != null &&
                    this.PromotionTypeName.Equals(input.PromotionTypeName))
                ) && 
                (
                    this.CalculationBase == input.CalculationBase ||
                    (this.CalculationBase != null &&
                    this.CalculationBase.Equals(input.CalculationBase))
                ) && 
                (
                    this.NoEffectOnSubsequentPriceDerivationRulesFlag == input.NoEffectOnSubsequentPriceDerivationRulesFlag ||
                    (this.NoEffectOnSubsequentPriceDerivationRulesFlag != null &&
                    this.NoEffectOnSubsequentPriceDerivationRulesFlag.Equals(input.NoEffectOnSubsequentPriceDerivationRulesFlag))
                ) && 
                (
                    this.ProhibitTransactionRelatedPriceDerivationRulesFlag == input.ProhibitTransactionRelatedPriceDerivationRulesFlag ||
                    (this.ProhibitTransactionRelatedPriceDerivationRulesFlag != null &&
                    this.ProhibitTransactionRelatedPriceDerivationRulesFlag.Equals(input.ProhibitTransactionRelatedPriceDerivationRulesFlag))
                ) && 
                (
                    this.CouponPrintoutID == input.CouponPrintoutID ||
                    (this.CouponPrintoutID != null &&
                    this.CouponPrintoutID.Equals(input.CouponPrintoutID))
                ) && 
                (
                    this.CouponPrintoutRule == input.CouponPrintoutRule ||
                    (this.CouponPrintoutRule != null &&
                    this.CouponPrintoutRule.Equals(input.CouponPrintoutRule))
                ) && 
                (
                    this.CouponPrintoutText == input.CouponPrintoutText ||
                    (this.CouponPrintoutText != null &&
                    this.CouponPrintoutText.Equals(input.CouponPrintoutText))
                ) && 
                (
                    this.ExclusiveFlag == input.ExclusiveFlag ||
                    (this.ExclusiveFlag != null &&
                    this.ExclusiveFlag.Equals(input.ExclusiveFlag))
                ) && 
                (
                    this.ConcurrenceControlVector == input.ConcurrenceControlVector ||
                    (this.ConcurrenceControlVector != null &&
                    this.ConcurrenceControlVector.Equals(input.ConcurrenceControlVector))
                ) && 
                (
                    this.AppliedCount == input.AppliedCount ||
                    (this.AppliedCount != null &&
                    this.AppliedCount.Equals(input.AppliedCount))
                ) && 
                (
                    this.PrintoutValidityPeriod == input.PrintoutValidityPeriod ||
                    (this.PrintoutValidityPeriod != null &&
                    this.PrintoutValidityPeriod.Equals(input.PrintoutValidityPeriod))
                ) && 
                (
                    this.XXCustom08 == input.XXCustom08 ||
                    (this.XXCustom08 != null &&
                    this.XXCustom08.Equals(input.XXCustom08))
                ) && 
                (
                    this.XXCustom10 == input.XXCustom10 ||
                    (this.XXCustom10 != null &&
                    this.XXCustom10.Equals(input.XXCustom10))
                ) && 
                (
                    this.XXCustom09 == input.XXCustom09 ||
                    (this.XXCustom09 != null &&
                    this.XXCustom09.Equals(input.XXCustom09))
                ) && 
                (
                    this.XXCustom07 == input.XXCustom07 ||
                    (this.XXCustom07 != null &&
                    this.XXCustom07.Equals(input.XXCustom07))
                ) && 
                (
                    this.XXCustom05 == input.XXCustom05 ||
                    (this.XXCustom05 != null &&
                    this.XXCustom05.Equals(input.XXCustom05))
                ) && 
                (
                    this.XXCustom06 == input.XXCustom06 ||
                    (this.XXCustom06 != null &&
                    this.XXCustom06.Equals(input.XXCustom06))
                ) && 
                (
                    this.XXCustom11 == input.XXCustom11 ||
                    (this.XXCustom11 != null &&
                    this.XXCustom11.Equals(input.XXCustom11))
                ) && 
                (
                    this.XXCustom12 == input.XXCustom12 ||
                    (this.XXCustom12 != null &&
                    this.XXCustom12.Equals(input.XXCustom12))
                ) && 
                (
                    this.XXCustom13 == input.XXCustom13 ||
                    (this.XXCustom13 != null &&
                    this.XXCustom13.Equals(input.XXCustom13))
                ) && 
                (
                    this.XXCustom14 == input.XXCustom14 ||
                    (this.XXCustom14 != null &&
                    this.XXCustom14.Equals(input.XXCustom14))
                ) && 
                (
                    this.XXCustom15 == input.XXCustom15 ||
                    (this.XXCustom15 != null &&
                    this.XXCustom15.Equals(input.XXCustom15))
                ) && 
                (
                    this.XXCustom03 == input.XXCustom03 ||
                    (this.XXCustom03 != null &&
                    this.XXCustom03.Equals(input.XXCustom03))
                ) && 
                (
                    this.XXCustom02 == input.XXCustom02 ||
                    (this.XXCustom02 != null &&
                    this.XXCustom02.Equals(input.XXCustom02))
                ) && 
                (
                    this.XXCustom04 == input.XXCustom04 ||
                    (this.XXCustom04 != null &&
                    this.XXCustom04.Equals(input.XXCustom04))
                ) && 
                (
                    this.XXCustom01 == input.XXCustom01 ||
                    (this.XXCustom01 != null &&
                    this.XXCustom01.Equals(input.XXCustom01))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.PromotionID != null)
                    hashCode = hashCode * 59 + this.PromotionID.GetHashCode();
                if (this.PriceDerivationRuleID != null)
                    hashCode = hashCode * 59 + this.PriceDerivationRuleID.GetHashCode();
                if (this.PriceDerivationRuleEligibilityID != null)
                    hashCode = hashCode * 59 + this.PriceDerivationRuleEligibilityID.GetHashCode();
                if (this.PromotionDescription != null)
                    hashCode = hashCode * 59 + this.PromotionDescription.GetHashCode();
                if (this.ReceiptPrinterName != null)
                    hashCode = hashCode * 59 + this.ReceiptPrinterName.GetHashCode();
                if (this.PromotionPriceDerivationRuleSequence != null)
                    hashCode = hashCode * 59 + this.PromotionPriceDerivationRuleSequence.GetHashCode();
                if (this.PromotionPriceDerivationRuleResolution != null)
                    hashCode = hashCode * 59 + this.PromotionPriceDerivationRuleResolution.GetHashCode();
                if (this.PromotionPriceDerivationRuleTypeCode != null)
                    hashCode = hashCode * 59 + this.PromotionPriceDerivationRuleTypeCode.GetHashCode();
                if (this.PriceModificationMethodCode != null)
                    hashCode = hashCode * 59 + this.PriceModificationMethodCode.GetHashCode();
                if (this.PriceDerivationRuleDescription != null)
                    hashCode = hashCode * 59 + this.PriceDerivationRuleDescription.GetHashCode();
                if (this.PromotionOriginatorTypeCode != null)
                    hashCode = hashCode * 59 + this.PromotionOriginatorTypeCode.GetHashCode();
                if (this.ExternalPromotionID != null)
                    hashCode = hashCode * 59 + this.ExternalPromotionID.GetHashCode();
                if (this.ExternalPriceDerivationRuleID != null)
                    hashCode = hashCode * 59 + this.ExternalPriceDerivationRuleID.GetHashCode();
                if (this.TriggerQuantity != null)
                    hashCode = hashCode * 59 + this.TriggerQuantity.GetHashCode();
                if (this.GiftCertificateExpirationDate != null)
                    hashCode = hashCode * 59 + this.GiftCertificateExpirationDate.GetHashCode();
                if (this.DiscountMethodCode != null)
                    hashCode = hashCode * 59 + this.DiscountMethodCode.GetHashCode();
                if (this.ProhibitPrintFlag != null)
                    hashCode = hashCode * 59 + this.ProhibitPrintFlag.GetHashCode();
                if (this.TenderTypeCode != null)
                    hashCode = hashCode * 59 + this.TenderTypeCode.GetHashCode();
                if (this.PromotionTypeName != null)
                    hashCode = hashCode * 59 + this.PromotionTypeName.GetHashCode();
                if (this.CalculationBase != null)
                    hashCode = hashCode * 59 + this.CalculationBase.GetHashCode();
                if (this.NoEffectOnSubsequentPriceDerivationRulesFlag != null)
                    hashCode = hashCode * 59 + this.NoEffectOnSubsequentPriceDerivationRulesFlag.GetHashCode();
                if (this.ProhibitTransactionRelatedPriceDerivationRulesFlag != null)
                    hashCode = hashCode * 59 + this.ProhibitTransactionRelatedPriceDerivationRulesFlag.GetHashCode();
                if (this.CouponPrintoutID != null)
                    hashCode = hashCode * 59 + this.CouponPrintoutID.GetHashCode();
                if (this.CouponPrintoutRule != null)
                    hashCode = hashCode * 59 + this.CouponPrintoutRule.GetHashCode();
                if (this.CouponPrintoutText != null)
                    hashCode = hashCode * 59 + this.CouponPrintoutText.GetHashCode();
                if (this.ExclusiveFlag != null)
                    hashCode = hashCode * 59 + this.ExclusiveFlag.GetHashCode();
                if (this.ConcurrenceControlVector != null)
                    hashCode = hashCode * 59 + this.ConcurrenceControlVector.GetHashCode();
                if (this.AppliedCount != null)
                    hashCode = hashCode * 59 + this.AppliedCount.GetHashCode();
                if (this.PrintoutValidityPeriod != null)
                    hashCode = hashCode * 59 + this.PrintoutValidityPeriod.GetHashCode();
                if (this.XXCustom08 != null)
                    hashCode = hashCode * 59 + this.XXCustom08.GetHashCode();
                if (this.XXCustom10 != null)
                    hashCode = hashCode * 59 + this.XXCustom10.GetHashCode();
                if (this.XXCustom09 != null)
                    hashCode = hashCode * 59 + this.XXCustom09.GetHashCode();
                if (this.XXCustom07 != null)
                    hashCode = hashCode * 59 + this.XXCustom07.GetHashCode();
                if (this.XXCustom05 != null)
                    hashCode = hashCode * 59 + this.XXCustom05.GetHashCode();
                if (this.XXCustom06 != null)
                    hashCode = hashCode * 59 + this.XXCustom06.GetHashCode();
                if (this.XXCustom11 != null)
                    hashCode = hashCode * 59 + this.XXCustom11.GetHashCode();
                if (this.XXCustom12 != null)
                    hashCode = hashCode * 59 + this.XXCustom12.GetHashCode();
                if (this.XXCustom13 != null)
                    hashCode = hashCode * 59 + this.XXCustom13.GetHashCode();
                if (this.XXCustom14 != null)
                    hashCode = hashCode * 59 + this.XXCustom14.GetHashCode();
                if (this.XXCustom15 != null)
                    hashCode = hashCode * 59 + this.XXCustom15.GetHashCode();
                if (this.XXCustom03 != null)
                    hashCode = hashCode * 59 + this.XXCustom03.GetHashCode();
                if (this.XXCustom02 != null)
                    hashCode = hashCode * 59 + this.XXCustom02.GetHashCode();
                if (this.XXCustom04 != null)
                    hashCode = hashCode * 59 + this.XXCustom04.GetHashCode();
                if (this.XXCustom01 != null)
                    hashCode = hashCode * 59 + this.XXCustom01.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
