/* 
 * GK application - OmniPOS Service API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 5.21.1-b03
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;

namespace IO.Swagger.Model
{
    /// <summary>
    /// PeripheralAccessSO &lt;p&gt;Login data of one specific periphery class in the specific retail store&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    [DataContract]
    public partial class ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO :  IEquatable<ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO" /> class.
        /// </summary>
        /// <param name="retailStoreID">&lt;p&gt;Retail store ID of the periphery access assignment&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: from Operator.BusinessUnitAssignment.BusinessUnitIdentification: BusinessUnitID or the corresponding retail store ID for the ExternalBusinessUnitID&lt;br /&gt;&lt;/p&gt; (required).</param>
        /// <param name="peripheralsTypeCode">&lt;p&gt;Identification of the periphery class. Possible values: &#39;Mobile&#39;, &#39;Web&#39;, &#39;POS&#39;, &#39;SCALE&#39;, &#39;RVM&#39;, &#39;ESL&#39; etc.&lt;br /&gt; This attribute allows to define different login data for different peripheral systems.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.PeripheralSystemType&lt;br /&gt;&lt;/p&gt; (required).</param>
        /// <param name="loginName">&lt;p&gt;Login name. The login name for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.LoginName&lt;br /&gt;&lt;/p&gt; (required).</param>
        /// <param name="loginPassword">&lt;p&gt;Password. The password for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.Password&lt;br /&gt;&lt;/p&gt;.</param>
        /// <param name="passwordCreateTimestamp">&lt;p&gt;Timestamp (date and time), when the password was created.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone) (required).</param>
        /// <param name="passwordFailedAttemptsCount">&lt;p&gt;Count of failed log in attempts. This value is reset after a successfully log in.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt; (required).</param>
        /// <param name="passwordLastSuccessfulLoginTimestamp">&lt;p&gt;Timestamp of last successfully log in&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone).</param>
        /// <param name="accessBlockingFlag">&lt;p&gt;Determines, if the access is blocked.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt; (required).</param>
        /// <param name="initialPasswordFlag">&lt;p&gt;Initial password flag&lt;br /&gt;&lt;/p&gt;.</param>
        /// <param name="xxcustom05">&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;.</param>
        /// <param name="xxcustom03">&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;.</param>
        /// <param name="xxcustom02">&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;.</param>
        /// <param name="xxcustom04">&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;.</param>
        /// <param name="xxcustom01">&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;.</param>
        public ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO(string retailStoreID = default(string), string peripheralsTypeCode = default(string), string loginName = default(string), string loginPassword = default(string), string passwordCreateTimestamp = default(string), int? passwordFailedAttemptsCount = default(int?), string passwordLastSuccessfulLoginTimestamp = default(string), bool? accessBlockingFlag = default(bool?), bool? initialPasswordFlag = default(bool?), string xxcustom05 = default(string), string xxcustom03 = default(string), string xxcustom02 = default(string), string xxcustom04 = default(string), string xxcustom01 = default(string))
        {
            // to ensure "retailStoreID" is required (not null)
            if (retailStoreID == null)
            {
                throw new InvalidDataException("retailStoreID is a required property for ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO and cannot be null");
            }
            else
            {
                this.RetailStoreID = retailStoreID;
            }
            // to ensure "peripheralsTypeCode" is required (not null)
            if (peripheralsTypeCode == null)
            {
                throw new InvalidDataException("peripheralsTypeCode is a required property for ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO and cannot be null");
            }
            else
            {
                this.PeripheralsTypeCode = peripheralsTypeCode;
            }
            // to ensure "loginName" is required (not null)
            if (loginName == null)
            {
                throw new InvalidDataException("loginName is a required property for ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO and cannot be null");
            }
            else
            {
                this.LoginName = loginName;
            }
            // to ensure "passwordCreateTimestamp" is required (not null)
            if (passwordCreateTimestamp == null)
            {
                throw new InvalidDataException("passwordCreateTimestamp is a required property for ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO and cannot be null");
            }
            else
            {
                this.PasswordCreateTimestamp = passwordCreateTimestamp;
            }
            // to ensure "passwordFailedAttemptsCount" is required (not null)
            if (passwordFailedAttemptsCount == null)
            {
                throw new InvalidDataException("passwordFailedAttemptsCount is a required property for ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO and cannot be null");
            }
            else
            {
                this.PasswordFailedAttemptsCount = passwordFailedAttemptsCount;
            }
            // to ensure "accessBlockingFlag" is required (not null)
            if (accessBlockingFlag == null)
            {
                throw new InvalidDataException("accessBlockingFlag is a required property for ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO and cannot be null");
            }
            else
            {
                this.AccessBlockingFlag = accessBlockingFlag;
            }
            this.LoginPassword = loginPassword;
            this.PasswordLastSuccessfulLoginTimestamp = passwordLastSuccessfulLoginTimestamp;
            this.InitialPasswordFlag = initialPasswordFlag;
            this.Xxcustom05 = xxcustom05;
            this.Xxcustom03 = xxcustom03;
            this.Xxcustom02 = xxcustom02;
            this.Xxcustom04 = xxcustom04;
            this.Xxcustom01 = xxcustom01;
        }
        
        /// <summary>
        /// &lt;p&gt;Retail store ID of the periphery access assignment&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: from Operator.BusinessUnitAssignment.BusinessUnitIdentification: BusinessUnitID or the corresponding retail store ID for the ExternalBusinessUnitID&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Retail store ID of the periphery access assignment&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: from Operator.BusinessUnitAssignment.BusinessUnitIdentification: BusinessUnitID or the corresponding retail store ID for the ExternalBusinessUnitID&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="retailStoreID", EmitDefaultValue=false)]
        public string RetailStoreID { get; set; }

        /// <summary>
        /// &lt;p&gt;Identification of the periphery class. Possible values: &#39;Mobile&#39;, &#39;Web&#39;, &#39;POS&#39;, &#39;SCALE&#39;, &#39;RVM&#39;, &#39;ESL&#39; etc.&lt;br /&gt; This attribute allows to define different login data for different peripheral systems.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.PeripheralSystemType&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identification of the periphery class. Possible values: &#39;Mobile&#39;, &#39;Web&#39;, &#39;POS&#39;, &#39;SCALE&#39;, &#39;RVM&#39;, &#39;ESL&#39; etc.&lt;br /&gt; This attribute allows to define different login data for different peripheral systems.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.PeripheralSystemType&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="peripheralsTypeCode", EmitDefaultValue=false)]
        public string PeripheralsTypeCode { get; set; }

        /// <summary>
        /// &lt;p&gt;Login name. The login name for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.LoginName&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Login name. The login name for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.LoginName&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="loginName", EmitDefaultValue=false)]
        public string LoginName { get; set; }

        /// <summary>
        /// &lt;p&gt;Password. The password for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.Password&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Password. The password for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.Password&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="loginPassword", EmitDefaultValue=false)]
        public string LoginPassword { get; set; }

        /// <summary>
        /// &lt;p&gt;Timestamp (date and time), when the password was created.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Timestamp (date and time), when the password was created.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        [DataMember(Name="passwordCreateTimestamp", EmitDefaultValue=false)]
        public string PasswordCreateTimestamp { get; set; }

        /// <summary>
        /// &lt;p&gt;Count of failed log in attempts. This value is reset after a successfully log in.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Count of failed log in attempts. This value is reset after a successfully log in.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="passwordFailedAttemptsCount", EmitDefaultValue=false)]
        public int? PasswordFailedAttemptsCount { get; set; }

        /// <summary>
        /// &lt;p&gt;Timestamp of last successfully log in&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Timestamp of last successfully log in&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        [DataMember(Name="passwordLastSuccessfulLoginTimestamp", EmitDefaultValue=false)]
        public string PasswordLastSuccessfulLoginTimestamp { get; set; }

        /// <summary>
        /// &lt;p&gt;Determines, if the access is blocked.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines, if the access is blocked.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="accessBlockingFlag", EmitDefaultValue=false)]
        public bool? AccessBlockingFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;Initial password flag&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Initial password flag&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="initialPasswordFlag", EmitDefaultValue=false)]
        public bool? InitialPasswordFlag { get; set; }

        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="xxcustom05", EmitDefaultValue=false)]
        public string Xxcustom05 { get; set; }

        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="xxcustom03", EmitDefaultValue=false)]
        public string Xxcustom03 { get; set; }

        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="xxcustom02", EmitDefaultValue=false)]
        public string Xxcustom02 { get; set; }

        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="xxcustom04", EmitDefaultValue=false)]
        public string Xxcustom04 { get; set; }

        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        [DataMember(Name="xxcustom01", EmitDefaultValue=false)]
        public string Xxcustom01 { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO {\n");
            sb.Append("  RetailStoreID: ").Append(RetailStoreID).Append("\n");
            sb.Append("  PeripheralsTypeCode: ").Append(PeripheralsTypeCode).Append("\n");
            sb.Append("  LoginName: ").Append(LoginName).Append("\n");
            sb.Append("  LoginPassword: ").Append(LoginPassword).Append("\n");
            sb.Append("  PasswordCreateTimestamp: ").Append(PasswordCreateTimestamp).Append("\n");
            sb.Append("  PasswordFailedAttemptsCount: ").Append(PasswordFailedAttemptsCount).Append("\n");
            sb.Append("  PasswordLastSuccessfulLoginTimestamp: ").Append(PasswordLastSuccessfulLoginTimestamp).Append("\n");
            sb.Append("  AccessBlockingFlag: ").Append(AccessBlockingFlag).Append("\n");
            sb.Append("  InitialPasswordFlag: ").Append(InitialPasswordFlag).Append("\n");
            sb.Append("  Xxcustom05: ").Append(Xxcustom05).Append("\n");
            sb.Append("  Xxcustom03: ").Append(Xxcustom03).Append("\n");
            sb.Append("  Xxcustom02: ").Append(Xxcustom02).Append("\n");
            sb.Append("  Xxcustom04: ").Append(Xxcustom04).Append("\n");
            sb.Append("  Xxcustom01: ").Append(Xxcustom01).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO);
        }

        /// <summary>
        /// Returns true if ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO instances are equal
        /// </summary>
        /// <param name="input">Instance of ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ComGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.RetailStoreID == input.RetailStoreID ||
                    (this.RetailStoreID != null &&
                    this.RetailStoreID.Equals(input.RetailStoreID))
                ) && 
                (
                    this.PeripheralsTypeCode == input.PeripheralsTypeCode ||
                    (this.PeripheralsTypeCode != null &&
                    this.PeripheralsTypeCode.Equals(input.PeripheralsTypeCode))
                ) && 
                (
                    this.LoginName == input.LoginName ||
                    (this.LoginName != null &&
                    this.LoginName.Equals(input.LoginName))
                ) && 
                (
                    this.LoginPassword == input.LoginPassword ||
                    (this.LoginPassword != null &&
                    this.LoginPassword.Equals(input.LoginPassword))
                ) && 
                (
                    this.PasswordCreateTimestamp == input.PasswordCreateTimestamp ||
                    (this.PasswordCreateTimestamp != null &&
                    this.PasswordCreateTimestamp.Equals(input.PasswordCreateTimestamp))
                ) && 
                (
                    this.PasswordFailedAttemptsCount == input.PasswordFailedAttemptsCount ||
                    (this.PasswordFailedAttemptsCount != null &&
                    this.PasswordFailedAttemptsCount.Equals(input.PasswordFailedAttemptsCount))
                ) && 
                (
                    this.PasswordLastSuccessfulLoginTimestamp == input.PasswordLastSuccessfulLoginTimestamp ||
                    (this.PasswordLastSuccessfulLoginTimestamp != null &&
                    this.PasswordLastSuccessfulLoginTimestamp.Equals(input.PasswordLastSuccessfulLoginTimestamp))
                ) && 
                (
                    this.AccessBlockingFlag == input.AccessBlockingFlag ||
                    (this.AccessBlockingFlag != null &&
                    this.AccessBlockingFlag.Equals(input.AccessBlockingFlag))
                ) && 
                (
                    this.InitialPasswordFlag == input.InitialPasswordFlag ||
                    (this.InitialPasswordFlag != null &&
                    this.InitialPasswordFlag.Equals(input.InitialPasswordFlag))
                ) && 
                (
                    this.Xxcustom05 == input.Xxcustom05 ||
                    (this.Xxcustom05 != null &&
                    this.Xxcustom05.Equals(input.Xxcustom05))
                ) && 
                (
                    this.Xxcustom03 == input.Xxcustom03 ||
                    (this.Xxcustom03 != null &&
                    this.Xxcustom03.Equals(input.Xxcustom03))
                ) && 
                (
                    this.Xxcustom02 == input.Xxcustom02 ||
                    (this.Xxcustom02 != null &&
                    this.Xxcustom02.Equals(input.Xxcustom02))
                ) && 
                (
                    this.Xxcustom04 == input.Xxcustom04 ||
                    (this.Xxcustom04 != null &&
                    this.Xxcustom04.Equals(input.Xxcustom04))
                ) && 
                (
                    this.Xxcustom01 == input.Xxcustom01 ||
                    (this.Xxcustom01 != null &&
                    this.Xxcustom01.Equals(input.Xxcustom01))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.RetailStoreID != null)
                    hashCode = hashCode * 59 + this.RetailStoreID.GetHashCode();
                if (this.PeripheralsTypeCode != null)
                    hashCode = hashCode * 59 + this.PeripheralsTypeCode.GetHashCode();
                if (this.LoginName != null)
                    hashCode = hashCode * 59 + this.LoginName.GetHashCode();
                if (this.LoginPassword != null)
                    hashCode = hashCode * 59 + this.LoginPassword.GetHashCode();
                if (this.PasswordCreateTimestamp != null)
                    hashCode = hashCode * 59 + this.PasswordCreateTimestamp.GetHashCode();
                if (this.PasswordFailedAttemptsCount != null)
                    hashCode = hashCode * 59 + this.PasswordFailedAttemptsCount.GetHashCode();
                if (this.PasswordLastSuccessfulLoginTimestamp != null)
                    hashCode = hashCode * 59 + this.PasswordLastSuccessfulLoginTimestamp.GetHashCode();
                if (this.AccessBlockingFlag != null)
                    hashCode = hashCode * 59 + this.AccessBlockingFlag.GetHashCode();
                if (this.InitialPasswordFlag != null)
                    hashCode = hashCode * 59 + this.InitialPasswordFlag.GetHashCode();
                if (this.Xxcustom05 != null)
                    hashCode = hashCode * 59 + this.Xxcustom05.GetHashCode();
                if (this.Xxcustom03 != null)
                    hashCode = hashCode * 59 + this.Xxcustom03.GetHashCode();
                if (this.Xxcustom02 != null)
                    hashCode = hashCode * 59 + this.Xxcustom02.GetHashCode();
                if (this.Xxcustom04 != null)
                    hashCode = hashCode * 59 + this.Xxcustom04.GetHashCode();
                if (this.Xxcustom01 != null)
                    hashCode = hashCode * 59 + this.Xxcustom01.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
