﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.AddCustomer
{
    /// <summary>
    /// Respuesta de la petición agregar cliente
    /// </summary>
    public class AddCustomerResponse : Respuesta
    {
        public int RequestID { get; set; }
        public string CustomerID { get; set; }
        public string Name { get; set; }
        public long YTDPoints { get; set; }
        private string _xml;

        public AddCustomerResponse(int sessionId,
                                   TipoMensaje messageType, 
                                   int requestID, 
                                   string customerID, 
                                   string name, 
                                   long yTDPoints) : base(sessionId, messageType)
        {
            RequestID = requestID;
            CustomerID = customerID;
            Name = name;
            YTDPoints = yTDPoints;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddCustomerResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <AddCustomerResult>
                            <RequestID>{RequestID}</RequestID>
                            <CustomerInfo>
                              <CustomerID>{CustomerID}</CustomerID>
                              <Name>{Name}</Name>
                              <YTDPoints>{YTDPoints}</YTDPoints>
                            </CustomerInfo>
                          </AddCustomerResult>
                        </schema:AddCustomerResponse>
                        """;

        }
    }
}
