﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace EvaPOS_API_FRAME.RespuestasXML.AddCustomer
{
    /// <summary>
    /// Respuesta cuando no se encuentra un cliente
    /// </summary>
    public class AddCustomerResponseNoEncontrado : Respuesta
    {
        public int RequestID { get; set; }
        public string Message { get; set; }
        public string ErrorCode { get; set; }
        private string _xml;

        public AddCustomerResponseNoEncontrado(int sessionId,
                                               TipoMensaje messageType, 
                                               int requestID, 
                                               string message, 
                                               string errorCode) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Message = message;
            ErrorCode = errorCode;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddCustomerResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <AddCustomerResult>
                            <RequestID>{RequestID}</RequestID>
                            <ExceptionResult>
                              <Message>{Message}</Message>
                              <ErrorCode>{ErrorCode}</ErrorCode>
                            </ExceptionResult>
                          </AddCustomerResult>
                        </schema:AddCustomerResponse>
                        """;

        }
    }
}
