﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.CancelTransaction
{
    /// <summary>
    /// Respuesta a petición de cancelar transacción
    /// </summary>
    public class VoidTransactionResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;
        
        public VoidTransactionResponse(int sessionId,
                                       TipoMensaje messageType,
                                       int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:VoidTransactionResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <VoidTransactionResult>
                            <RequestID>{RequestID}</RequestID>
                          </VoidTransactionResult>
                        </schema:VoidTransactionResponse>
                        """;
        }
    }
}
