﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Evento de respuesta.
    /// </summary>
    public class POSBCStatusEvent : Respuesta
    {
        public string Severity { get; private set; }
        public string Status { get; private set; }
        public string Message { get; private set; }
        private string _xml;

        public POSBCStatusEvent(int sessionId,
                                TipoMensaje messageType,
                                string severity,
                                string status,
                                string message) : base(sessionId, messageType)
        {
            Severity = severity;
            Status = status;
            Message = message;
        }

        // P2L_3_POSBCStatusEvent
        public override string TextoXML
        {
            get => _xml = $""" 
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSBCStatusEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                            <POSBCStatus>
                                <Severity>{Severity}</Severity>
                                <Status>{Status}</Status>
                                <StatusMessage>{Message}</StatusMessage>
                            </POSBCStatus>
                        </schema:POSBCStatusEvent>
                        """;
        }
    }
}
