﻿using EvaPOS_API_FRAME.DTO;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    public class POSReceiptEvent: Respuesta
    {
        public int RequestID { get; set; }
        public string Type { get; set; }
        public int Index { get; set; }
        public string Section { get; set; }
        public int Group { get; set; }
        public int Feeds { get; set; }
        public string Align { get; set; }
        public string LineCategory { get; set; }
        public string LineType { get; set; }
        public string Text { get; set; }
        //este valor es referente al tipo de evento que se tiene que mandar, o se manda ADD O MODIFY
        public string ValorXml { get; set; }
        private string _xml;

        public POSReceiptEvent(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string type,
                                 int index,
                                 string section,
                                 int group,
                                 int feeds,
                                 string align,
                                 string lineCategory,
                                 string lineType,
                                 string text,
                                 string valorXml) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Type = type;
            Index = index;
            Section = section;
            Group = group;
            Feeds = feeds;
            Align = align;
            LineCategory = lineCategory;
            LineType = lineType;
            Text = text;
            ValorXml = valorXml;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSReceiptEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema"
                                                UpdateType="{ValorXml}">
                          <RequestID>{RequestID}</RequestID>
                          <Type>{Type}</Type>
                          <Index>{Index}</Index>
                          <Section>{Section}</Section>
                          <Group>{Group}</Group>
                          <FormattedReceiptLineList>
                            <FormattedReceiptLine>
                              <Feeds>{Feeds}</Feeds>
                              <Align>{Align}</Align>
                              <LineCategory>{LineCategory}</LineCategory>
                              <LineType>{LineType}</LineType>
                              <TextReceiptLine>
                                <Text>{Text}</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                          </FormattedReceiptLineList>
                        </schema:POSReceiptEvent>
                        """;
        }
    }
}
